/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.List;
import org.meta2project.model.AnnotatedEntity;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;

public class AnnotationTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    private static void testAnnotationEntity(AnnotatedEntity ae) throws Exception {
        List<String> ls = ae.getAnnotationNames();
        int baseSize = ls.size();
        String t = ae.getAnnotation("http://meta2project.org/model#title");
        AnnotationTestCase.assertNull((Object)t);
        String v = "Sample title";
        ae.putAnnotation("http://meta2project.org/model#title", v);
        t = ae.getAnnotation("http://meta2project.org/model#title");
        AnnotationTestCase.assertEquals((String)v, (String)t);
        ae.putAnnotation("org.meta2project.model.Title", v + 1);
        t = ae.getAnnotation("http://meta2project.org/model#title");
        AnnotationTestCase.assertEquals((String)(v + 1), (String)t);
        String n = "http://name.test.com#name";
        String v2 = "another";
        ae.putAnnotation(n, v2);
        t = ae.getAnnotation(n);
        AnnotationTestCase.assertEquals((String)v2, (String)t);
        String v3 = "another2";
        ae.putAnnotation(n, v3);
        t = ae.getAnnotation(n);
        AnnotationTestCase.assertEquals((String)v3, (String)t);
        ls = ae.getAnnotationNames();
        AnnotationTestCase.assertEquals((int)(baseSize + 2), (int)ls.size());
        AnnotationTestCase.assertTrue((boolean)ls.contains("http://meta2project.org/model#title"));
        AnnotationTestCase.assertTrue((boolean)ls.contains(n));
        ae.putAnnotation(n, null);
        ls = ae.getAnnotationNames();
        AnnotationTestCase.assertEquals((int)(baseSize + 1), (int)ls.size());
        AnnotationTestCase.assertTrue((boolean)ls.contains("http://meta2project.org/model#title"));
    }

    public void testAnnotationOntology() throws Exception {
        AnnotationTestCase.testAnnotationEntity(this.ont);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationOntObject() throws Exception {
        OntObject obj = this.ont.createOntObject("ontobject", new Object[0]);
        try {
            AnnotationTestCase.testAnnotationEntity(obj);
        }
        finally {
            obj.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationClass() throws Exception {
        OntClass cl = this.ont.createOntClass("ontclass", new OntClass[0]);
        try {
            AnnotationTestCase.testAnnotationEntity(cl);
        }
        finally {
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationTProperty() throws Exception {
        TProperty tprop = this.ont.createTProperty("name", null, null, null, null);
        try {
            AnnotationTestCase.testAnnotationEntity(tprop);
        }
        finally {
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationOProperty() throws Exception {
        OProperty oprop = this.ont.createOProperty("name", null, null, null, null);
        try {
            AnnotationTestCase.testAnnotationEntity(oprop);
        }
        finally {
            oprop.delete();
        }
    }
}

