/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OntClass;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.NotFoundException;

public class CreateDeleteTestCase
extends SessionTestCase {
    private static final String NAME = "testname";
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void basicTestEntity(NamedEntity entity, String url, String name) {
        CreateDeleteTestCase.assertEquals((String)(url + '#' + name), (String)entity.getFullName());
        if (entity instanceof TProperty) {
            TProperty entity2 = this.ont.getTProperty(name);
            TProperty entity3 = this.con.getTPropertyByFullName(entity.getFullName());
            CreateDeleteTestCase.assertEquals((String)entity.getFullName(), (String)entity2.getFullName());
            CreateDeleteTestCase.assertEquals((String)entity.getFullName(), (String)entity3.getFullName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateTProperty() throws Exception {
        TProperty tprop = this.ont.createTProperty(NAME, null, null, null, null);
        try {
            this.basicTestEntity(tprop, "http://meta2.teacode.com/testcase", NAME);
        }
        finally {
            tprop.delete();
        }
        tprop = this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
        try {
            this.basicTestEntity(tprop, "http://meta2.teacode.com/testcase", NAME);
        }
        finally {
            tprop.delete();
        }
        tprop = this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, null);
        try {
            this.basicTestEntity(tprop, "http://meta2.teacode.com/testcase", NAME);
        }
        finally {
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateTPropertyDub() throws Exception {
        TProperty tprop = this.ont.createTProperty(NAME, null, null, null, null);
        try {
            try {
                this.ont.createTProperty(NAME, null, null, null, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
        }
        finally {
            tprop.delete();
        }
        tprop = this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
        try {
            try {
                this.ont.createTProperty(NAME, null, null, null, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
        }
        finally {
            tprop.delete();
        }
        tprop = this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, null);
        try {
            try {
                this.ont.createTProperty(NAME, null, null, null, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException e) {
                // empty catch block
            }
            try {
                this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, null);
                CreateDeleteTestCase.fail((String)"should raise AlreadyExistsException");
            }
            catch (AlreadyExistsException alreadyExistsException) {
                // empty catch block
            }
        }
        finally {
            tprop.delete();
        }
    }

    public void testDeleteTProperty() throws Exception {
        TProperty tprop = this.ont.createTProperty(NAME, null, (Type)null, (Integer)0, (Integer)1);
        tprop.delete();
        try {
            this.ont.getTProperty(NAME);
            CreateDeleteTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateType() throws Exception {
        Type type = this.ont.createType("supertype");
        try {
            String n = type.getFullName();
            Type type2 = this.con.getTypeByFullName(n);
            CreateDeleteTestCase.assertEquals((String)type.getFullName(), (String)type2.getFullName());
            type2 = this.ont.getType("supertype");
            CreateDeleteTestCase.assertEquals((String)type.getFullName(), (String)type2.getFullName());
            CreateDeleteTestCase.assertEquals((Object)type, (Object)type2);
            CreateDeleteTestCase.assertTrue((boolean)this.ont.getAllTypes().contains(type));
            CreateDeleteTestCase.assertTrue((boolean)this.ont.getAllTypes().contains(type2));
            String newName = "newtypename";
            type.setName("newtypename");
            CreateDeleteTestCase.assertEquals((String)"newtypename", (String)type.getName());
            type2 = this.ont.getType("newtypename");
            CreateDeleteTestCase.assertEquals((String)"newtypename", (String)type2.getName());
            CreateDeleteTestCase.assertEquals((String)type2.getFullName(), (String)type.getFullName());
            CreateDeleteTestCase.assertEquals((Object)type2, (Object)type);
            CreateDeleteTestCase.assertTrue((boolean)this.ont.getAllTypes().contains(type));
            CreateDeleteTestCase.assertTrue((boolean)this.ont.getAllTypes().contains(type2));
            type.setName("newtypename");
            type.setName("supertype");
        }
        finally {
            type.delete();
        }
        try {
            this.ont.getType("supertype");
            CreateDeleteTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEntity() throws Exception {
        OntClass cl = this.ont.createOntClass("123", new OntClass[0]);
        try {
            NamedEntity o = this.con.getEntity(cl.getFullName());
            CreateDeleteTestCase.assertTrue((boolean)(o instanceof OntClass));
            NamedEntity o2 = this.con.getEntity(this.ont.getURI() + '#' + 333);
            CreateDeleteTestCase.assertTrue((o2 == null ? 1 : 0) != 0);
        }
        finally {
            cl.delete();
        }
    }
}

