/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.event.OPropertyEvent;
import org.meta2project.model.event.OPropertyListener;
import org.meta2project.model.event.OntClassEvent;
import org.meta2project.model.event.OntClassListener;
import org.meta2project.model.event.OntObjectEvent;
import org.meta2project.model.event.OntObjectListener;
import org.meta2project.model.event.OntoListener;
import org.meta2project.model.event.OntologyEvent;
import org.meta2project.model.event.OntologyRenamedEvent;
import org.meta2project.model.event.TPropertyEvent;
import org.meta2project.model.event.TPropertyListener;
import org.meta2project.model.test.support.SessionTestCase;

public class ListenerTestCase
extends SessionTestCase {
    private static final int LISTENERS = 20;
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnto() throws Exception {
        ArrayList<TestOntoListener> listeners = new ArrayList<TestOntoListener>();
        for (int t = 0; t < 20; ++t) {
            TestOntoListener listener = new TestOntoListener();
            listeners.add(listener);
            this.session.getListenerManager().addOntoListener(listener);
        }
        try {
            String name1 = "http://onto1";
            String name2 = "http://ont2";
            Ontology ont = this.con.createOntology(name1);
            try {
                for (TestOntoListener listener : listeners) {
                    ListenerTestCase.assertEquals((String)name1, (String)listener.lastCreatedURL);
                }
                Ontology ont2 = this.con.createOntology(name2);
                try {
                    for (TestOntoListener listener : listeners) {
                        ListenerTestCase.assertEquals((String)name2, (String)listener.lastCreatedURL);
                    }
                    ont2.delete();
                }
                catch (Throwable throwable) {
                    ont2.delete();
                    for (TestOntoListener listener : listeners) {
                        ListenerTestCase.assertEquals((String)name2, (String)listener.lastDeletedURL);
                    }
                    throw throwable;
                }
                for (TestOntoListener listener : listeners) {
                    ListenerTestCase.assertEquals((String)name2, (String)listener.lastDeletedURL);
                }
                ont.delete();
            }
            catch (Throwable throwable) {
                ont.delete();
                for (TestOntoListener listener : listeners) {
                    ListenerTestCase.assertEquals((String)name1, (String)listener.lastDeletedURL);
                }
                throw throwable;
            }
            for (TestOntoListener listener : listeners) {
                ListenerTestCase.assertEquals((String)name1, (String)listener.lastDeletedURL);
            }
        }
        finally {
            for (TestOntoListener listener : listeners) {
                this.session.getListenerManager().removeOntoListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntObjectListener() throws Exception {
        TestOntObjectListener listener = new TestOntObjectListener();
        this.session.getListenerManager().addOntObjectListener(listener);
        try {
            OntObject obj = null;
            NamedEntity obj2 = null;
            try {
                obj = this.ont.createOntObject(new Object[0]);
                ListenerTestCase.assertEquals((String)obj.getOntology().getURI(), (String)listener.lastCreatedURL);
                ListenerTestCase.assertEquals((String)obj.getName(), (String)listener.lastCreatedName);
                obj2 = this.ont.createOntObject("a-name", new Object[0]);
                ListenerTestCase.assertEquals((String)obj2.getOntology().getURI(), (String)listener.lastCreatedURL);
                ListenerTestCase.assertEquals((String)obj2.getName(), (String)listener.lastCreatedName);
            }
            finally {
                if (obj2 != null) {
                    String ont = obj2.getOntology().getURI();
                    String name = obj2.getName();
                    obj2.delete();
                    ListenerTestCase.assertEquals((String)ont, (String)listener.lastDeleteURL);
                    ListenerTestCase.assertEquals((String)name, (String)listener.lastCreatedName);
                }
                if (obj != null) {
                    obj.delete();
                }
            }
        }
        finally {
            this.session.getListenerManager().removeOntObjectListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntClassDelete() throws Exception {
        OntClass cl = this.ont.createOntClass("test1", new OntClass[0]);
        try {
            TestOntClassListener listener = new TestOntClassListener();
            this.session.getListenerManager().addOntClassListener(listener);
            try {
                ListenerTestCase.assertFalse((boolean)listener.deleted);
                cl.delete();
                cl = null;
                ListenerTestCase.assertTrue((boolean)listener.deleted);
            }
            finally {
                this.session.getListenerManager().removeOntClassListener(listener);
            }
        }
        finally {
            if (cl != null) {
                cl.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void OntClassDelete2() {
        OntClass cl = this.ont.createOntClass("base", new OntClass[0]);
        OntClass cl2 = this.ont.createOntClass("child", cl);
        try {
            TestOntClassListener listener = new TestOntClassListener();
            try {
                this.session.getListenerManager().addOntClassListener(listener);
                listener.deleted = false;
                ListenerTestCase.assertFalse((boolean)listener.deleted);
                try {
                    cl.delete();
                    ListenerTestCase.fail((String)"should raise Exception");
                }
                catch (Exception e) {
                    // empty catch block
                }
                ListenerTestCase.assertFalse((boolean)listener.deleted);
                cl2.delete();
                cl2 = null;
                ListenerTestCase.assertTrue((boolean)listener.deleted);
                listener.deleted = false;
                ListenerTestCase.assertFalse((boolean)listener.deleted);
                cl.delete();
                cl = null;
                ListenerTestCase.assertTrue((boolean)listener.deleted);
            }
            finally {
                this.session.getListenerManager().removeOntClassListener(listener);
            }
        }
        finally {
            if (cl != null) {
                cl.delete();
            }
            if (cl2 != null) {
                cl2.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTPropertyListener() throws Exception {
        String name = this.ont.getURI() + "#tproperty";
        TestTPropertyListener listener = new TestTPropertyListener();
        this.session.getListenerManager().addTPropertyListener(listener);
        ListenerTestCase.assertEquals(null, (String)listener.lastCreated);
        ListenerTestCase.assertEquals(null, (String)listener.lastDeleted);
        TProperty tprop = this.ont.createTProperty("tproperty", null, null, null, null);
        try {
            ListenerTestCase.assertEquals((String)name, (String)listener.lastCreated);
            listener.lastCreated = null;
            ListenerTestCase.assertEquals(null, (String)listener.lastDeleted);
        }
        finally {
            tprop.delete();
        }
        ListenerTestCase.assertEquals(null, (String)listener.lastCreated);
        ListenerTestCase.assertEquals((String)name, (String)listener.lastDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOPropertyListener() throws Exception {
        String name = this.ont.getURI() + "#oproperty";
        TestOPropertyListener listener = new TestOPropertyListener();
        this.session.getListenerManager().addOPropertyListener(listener);
        ListenerTestCase.assertEquals(null, (String)listener.lastCreated);
        ListenerTestCase.assertEquals(null, (String)listener.lastDeleted);
        OProperty oprop = this.ont.createOProperty("oproperty", null, null, null, null);
        try {
            ListenerTestCase.assertEquals((String)name, (String)listener.lastCreated);
            listener.lastCreated = null;
            ListenerTestCase.assertEquals(null, (String)listener.lastDeleted);
        }
        finally {
            oprop.delete();
        }
        ListenerTestCase.assertEquals(null, (String)listener.lastCreated);
        ListenerTestCase.assertEquals((String)name, (String)listener.lastDeleted);
    }

    protected static class TestOPropertyListener
    implements OPropertyListener {
        String lastCreated;
        String lastDeleted;

        protected TestOPropertyListener() {
        }

        @Override
        public void oPropertyCreated(OPropertyEvent event) {
            this.lastCreated = event.getURI() + '#' + event.getName();
        }

        @Override
        public void oPropertyDeleted(OPropertyEvent event) {
            this.lastDeleted = event.getURI() + '#' + event.getName();
        }
    }

    protected static class TestTPropertyListener
    implements TPropertyListener {
        String lastCreated;
        String lastDeleted;

        protected TestTPropertyListener() {
        }

        @Override
        public void tPropertyCreated(TPropertyEvent event) {
            this.lastCreated = event.getURI() + '#' + event.getName();
        }

        @Override
        public void tPropertyDeleted(TPropertyEvent event) {
            this.lastDeleted = event.getURI() + '#' + event.getName();
        }
    }

    protected static class TestOntClassListener
    implements OntClassListener {
        boolean deleted = false;

        protected TestOntClassListener() {
        }

        @Override
        public void ontClassCreated(OntClassEvent event) {
        }

        @Override
        public void ontClassDeleted(OntClassEvent event) {
            this.deleted = true;
        }
    }

    protected static class TestOntObjectListener
    implements OntObjectListener {
        String lastCreatedURL;
        String lastCreatedName;
        String lastDeleteURL;
        protected String lastDeleteName;

        protected TestOntObjectListener() {
        }

        @Override
        public void ontObjectCreated(OntObjectEvent event) {
            this.lastCreatedName = event.getName();
            this.lastCreatedURL = event.getURI();
        }

        @Override
        public void ontObjectDeleted(OntObjectEvent event) {
            this.lastCreatedName = event.getName();
            this.lastDeleteURL = event.getURI();
        }
    }

    protected static class TestOntoListener
    implements OntoListener {
        String lastCreatedURL;
        String lastDeletedURL;

        protected TestOntoListener() {
        }

        @Override
        public void ontologyCreated(OntologyEvent event) {
            this.lastCreatedURL = event.getURI();
        }

        @Override
        public void ontologyRenamed(OntologyRenamedEvent event) {
        }

        @Override
        public void ontologyDeleted(OntologyEvent event) {
            this.lastDeletedURL = event.getURI();
        }
    }
}

