/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.Property;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.OntologyCleaner;
import org.meta2project.model.test.support.SessionTestCase;
import org.meta2project.model.test.support.WorkerCleaner;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.TempHelper;
import org.ontobox.box.helper.VMap;
import org.ontobox.box.helper.Values;
import org.ontobox.box.query.QContext;
import org.ontobox.box.query.Query;

public class OntObjectTestCase
extends SessionTestCase {
    private static final String NAME = "testobject";
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntObject() throws Exception {
        OntObject obj = this.ont.createOntObject(NAME, new Object[0]);
        try {
            OntObjectTestCase.assertEquals((String)"http://meta2.teacode.com/testcase#testobject", (String)obj.getFullName());
            OntObject obj2 = this.ont.getOntObject(NAME);
            OntObjectTestCase.assertEquals((String)obj.getFullName(), (String)obj2.getFullName());
            obj2 = this.con.getOntObjectByFullName(obj.getFullName());
            OntObjectTestCase.assertEquals((String)obj.getFullName(), (String)obj2.getFullName());
        }
        finally {
            obj.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntObject2() throws Exception {
        OntObject obj = this.ont.createOntObject(new Object[0]);
        try {
            OntObject obj2 = this.con.getOntObjectByFullName(obj.getFullName());
            OntObjectTestCase.assertEquals((String)obj.getFullName(), (String)obj2.getFullName());
        }
        finally {
            obj.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntObjectDub() throws Exception {
        OntObject obj = this.ont.createOntObject(NAME, new Object[0]);
        try {
            this.ont.createOntObject(NAME, new Object[0]);
            OntObjectTestCase.fail((String)"should raise AlreadyExistsException");
        }
        catch (AlreadyExistsException alreadyExistsException) {
        }
        finally {
            obj.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateOntObjectFast() throws Exception {
        ArrayList<OntObject> objs = new ArrayList<OntObject>();
        try {
            int NUM = 1000;
            for (int t = 0; t < NUM; ++t) {
                OntObject obj = this.ont.createOntObject(new Object[0]);
                objs.add(obj);
            }
        }
        finally {
            for (OntObject obj : objs) {
                obj.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteOntObject() throws Exception {
        OntObject obj = this.ont.createOntObject(NAME, new Object[0]);
        try {
            OntObject o1 = this.ont.getOntObject(NAME);
            OntObject o2 = this.con.getOntObjectByFullName(this.ont.getURI() + '#' + NAME);
            OntObjectTestCase.assertEquals((Object)o1, (Object)o2);
            OntObjectTestCase.assertEquals((Object)o1.getOntology(), (Object)o2.getOntology());
            OntObjectTestCase.assertEquals((String)o1.getName(), (String)o2.getName());
            OntObjectTestCase.assertEquals((String)o1.getFullName(), (String)o2.getFullName());
        }
        finally {
            obj.delete();
        }
        try {
            this.ont.getOntObject(NAME);
            OntObjectTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException e) {
            // empty catch block
        }
        try {
            this.con.getOntObjectByFullName(this.ont.getURI() + '#' + NAME);
            OntObjectTestCase.fail((String)"should raise NotFoundException");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveOValue() throws Exception {
        OntObject obj = this.ont.createOntObject(new Object[0]);
        OntObject tempObj1 = this.ont.createOntObject(new Object[0]);
        OntObject tempObj2 = this.ont.createOntObject(new Object[0]);
        OntObject tempObj3 = this.ont.createOntObject(new Object[0]);
        OProperty oprop = this.ont.createOProperty("oprop", null, null, null, null);
        try {
            List<OntObject> values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertTrue((boolean)values.isEmpty());
            obj.addOPropertyValue(oprop, tempObj1);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)1, (int)values.size());
            OntObjectTestCase.assertEquals((String)tempObj1.getFullName(), (String)values.get(0).getFullName());
            obj.addOPropertyValue(oprop, tempObj3);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)2, (int)values.size());
            OntObjectTestCase.assertEquals((String)tempObj1.getFullName(), (String)values.get(0).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj3.getFullName(), (String)values.get(1).getFullName());
            obj.addOPropertyValue(oprop, 1, tempObj2);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)3, (int)values.size());
            OntObjectTestCase.assertEquals((String)tempObj1.getFullName(), (String)values.get(0).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj2.getFullName(), (String)values.get(1).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj3.getFullName(), (String)values.get(2).getFullName());
            try {
                obj.addOPropertyValue(oprop, 4, tempObj1);
                OntObjectTestCase.fail((String)"should raise an exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            OntObjectTestCase.assertEquals((int)3, (int)values.size());
            OntObjectTestCase.assertEquals((String)tempObj1.getFullName(), (String)values.get(0).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj2.getFullName(), (String)values.get(1).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj3.getFullName(), (String)values.get(2).getFullName());
            obj.removeOPropertyValue(oprop, 1);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)2, (int)values.size());
            OntObjectTestCase.assertEquals((String)tempObj1.getFullName(), (String)values.get(0).getFullName());
            OntObjectTestCase.assertEquals((String)tempObj3.getFullName(), (String)values.get(1).getFullName());
            obj.removeOPropertyValue(oprop, 0);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)1, (int)values.size());
            obj.removeOPropertyValue(oprop, 0);
            values = obj.getOPropertyValues(oprop);
            OntObjectTestCase.assertEquals((int)0, (int)values.size());
            try {
                obj.removeOPropertyValue(oprop, 0);
                OntObjectTestCase.fail((String)"should raise an exception");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            obj.delete();
            tempObj1.delete();
            tempObj2.delete();
            tempObj3.delete();
            oprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddRemoveTValue() throws Exception {
        String v1 = "value1";
        String v2 = "value2";
        String v3 = "value3";
        OntObject obj = this.ont.createOntObject(new Object[0]);
        TProperty tprop = this.ont.createTProperty("tprop", null, null, null, null);
        try {
            List<String> strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertTrue((boolean)strings.isEmpty());
            obj.addTPropertyString(tprop, v1);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)1, (int)strings.size());
            OntObjectTestCase.assertEquals((String)v1, (String)strings.get(0));
            obj.addTPropertyString(tprop, v3);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)2, (int)strings.size());
            OntObjectTestCase.assertEquals((String)v1, (String)strings.get(0));
            OntObjectTestCase.assertEquals((String)v3, (String)strings.get(1));
            obj.addTPropertyString(tprop, 1, v2);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)3, (int)strings.size());
            OntObjectTestCase.assertEquals((String)v1, (String)strings.get(0));
            OntObjectTestCase.assertEquals((String)v2, (String)strings.get(1));
            OntObjectTestCase.assertEquals((String)v3, (String)strings.get(2));
            try {
                obj.addTPropertyString(tprop, 4, v1);
                OntObjectTestCase.fail((String)"should raise an exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            OntObjectTestCase.assertEquals((int)3, (int)strings.size());
            OntObjectTestCase.assertEquals((String)v1, (String)strings.get(0));
            OntObjectTestCase.assertEquals((String)v2, (String)strings.get(1));
            OntObjectTestCase.assertEquals((String)v3, (String)strings.get(2));
            obj.removeTPropertyValue(tprop, 1);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)2, (int)strings.size());
            OntObjectTestCase.assertEquals((String)v1, (String)strings.get(0));
            OntObjectTestCase.assertEquals((String)v3, (String)strings.get(1));
            obj.removeTPropertyValue(tprop, 0);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)1, (int)strings.size());
            obj.removeTPropertyValue(tprop, 0);
            strings = obj.getTPropertyStrings(tprop);
            OntObjectTestCase.assertEquals((int)0, (int)strings.size());
            try {
                obj.removeTPropertyValue(tprop, 0);
                OntObjectTestCase.fail((String)"should raise an exception");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            obj.delete();
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllOntObjects() throws Exception {
        OntObject obj1 = this.ont.createOntObject(new Object[0]);
        OntObject obj2 = this.ont.createOntObject(new Object[0]);
        OntObject obj3 = this.ont.createOntObject(new Object[0]);
        try {
            Collection<OntObject> col = this.ont.getAllOntObjects();
            OntObjectTestCase.assertEquals((int)3, (int)col.size());
            for (OntObject object : col) {
                if (object.equals(obj1) || object.equals(obj2) || object.equals(obj3)) continue;
                OntObjectTestCase.fail((String)("unknown object returned (" + object.getFullName() + ')'));
            }
        }
        finally {
            obj3.delete();
            obj2.delete();
            obj1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateObjectInit() throws Exception {
        OntClass c1 = this.ont.createOntClass("someclass1", new OntClass[0]);
        OntClass c2 = this.ont.createOntClass("someclass2", new OntClass[0]);
        TProperty tprop = this.ont.createTProperty("tprop", c1, "http://ontobox.org/#string", 0, 1);
        OntObject obj1 = this.ont.createOntObject(c1);
        obj1.addTPropertyString(tprop, "123");
        OntObject obj2 = this.ont.createOntObject("an-object", c1, c2);
        try {
            OntObjectTestCase.assertTrue((boolean)obj1.getOntClasses().contains(c1));
            OntObjectTestCase.assertTrue((boolean)obj2.getOntClasses().contains(c1));
            OntObjectTestCase.assertTrue((boolean)obj2.getOntClasses().contains(c2));
            OntObjectTestCase.assertEquals((String)obj1.getTPropertyString(tprop), (String)"123");
        }
        finally {
            obj1.removeAllValues();
            obj1.delete();
            obj2.delete();
            tprop.delete();
            c1.delete();
            c2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetAllOntObjectsForOntClass() throws Exception {
        OntClass baseCl = this.ont.createOntClass("baseClass", new OntClass[0]);
        OntClass child1 = this.ont.createOntClass("child1", new OntClass[0]);
        OntClass child2 = this.ont.createOntClass("child2", new OntClass[0]);
        OntClass child3 = this.ont.createOntClass("child3", new OntClass[0]);
        try {
            baseCl.addSubClass(child1);
            baseCl.addSubClass(child2);
            child1.addSubClass(child3);
            OntObject objB = this.ont.createOntObject(baseCl);
            OntObject obj1 = this.ont.createOntObject(child1);
            OntObject obj2 = this.ont.createOntObject(child2);
            OntObject obj3 = this.ont.createOntObject(child3);
            try {
                Collection<OntObject> c = baseCl.getOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(objB));
                c = baseCl.getAllOntObjects();
                OntObjectTestCase.assertEquals((int)4, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(objB));
                OntObjectTestCase.assertTrue((boolean)c.contains(obj1));
                OntObjectTestCase.assertTrue((boolean)c.contains(obj2));
                OntObjectTestCase.assertTrue((boolean)c.contains(obj3));
                c = child1.getAllOntObjects();
                OntObjectTestCase.assertEquals((int)2, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj1));
                OntObjectTestCase.assertTrue((boolean)c.contains(obj3));
                c = child1.getOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj1));
                c = child2.getAllOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj2));
                OntObjectTestCase.assertEquals((String)obj2.getFullName(), (String)c.iterator().next().getFullName());
                c = child2.getOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj2));
                c = child3.getAllOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj3));
                OntObjectTestCase.assertEquals((String)obj3.getFullName(), (String)c.iterator().next().getFullName());
                c = child3.getOntObjects();
                OntObjectTestCase.assertEquals((int)1, (int)c.size());
                OntObjectTestCase.assertTrue((boolean)c.contains(obj3));
            }
            finally {
                obj3.delete();
                obj2.delete();
                obj1.delete();
                objB.delete();
            }
        }
        finally {
            child3.delete();
            child2.delete();
            child1.delete();
            baseCl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectSetName() throws Exception {
        OntObject obj1 = this.ont.createOntObject(new Object[0]);
        OntObject obj2 = this.ont.createOntObject("justaname", new Object[0]);
        try {
            obj1.setName("test1");
            obj2.setName("test2");
            OntObjectTestCase.assertEquals((String)"test1", (String)obj1.getName());
            OntObjectTestCase.assertEquals((String)"test2", (String)obj2.getName());
            try {
                obj2.setName("test1");
                OntObjectTestCase.fail((String)"should raise Exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            OntObjectTestCase.assertEquals((String)"test1", (String)obj1.getName());
            OntObjectTestCase.assertEquals((String)"test2", (String)obj2.getName());
            OntObject o1 = this.ont.getOntObject("test1");
            OntObject o2 = this.ont.getOntObject("test2");
            OntObjectTestCase.assertEquals((String)obj1.getFullName(), (String)o1.getFullName());
            OntObjectTestCase.assertEquals((String)obj2.getFullName(), (String)o2.getFullName());
            obj1.setName(obj1.getName());
            obj2.setName(obj2.getName());
        }
        finally {
            obj1.delete();
            obj2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetPropertiesByShortName() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            Collection<Property> properties;
            OntClass baseCl = this.ont.createOntClass("base", new OntClass[0]);
            cleaner.addEntity(baseCl);
            OntClass base2Cl = this.ont.createOntClass("base2", new OntClass[0]);
            cleaner.addEntity(base2Cl);
            OntClass subCl = this.ont.createOntClass("subclass", new OntClass[0]);
            cleaner.addEntity(subCl);
            OProperty o1 = this.ont.createOProperty("o1", null, null, 0, 1);
            cleaner.addEntity(o1);
            OProperty o2 = this.ont.createOProperty("o2", baseCl, null, 0, 1);
            cleaner.addEntity(o2);
            OProperty o3 = this.ont.createOProperty("o3", subCl, null, 0, 1);
            cleaner.addEntity(o3);
            OProperty o4 = this.ont.createOProperty("o4", base2Cl, null, 0, 1);
            cleaner.addEntity(o4);
            TProperty t1 = this.ont.createTProperty("t1", (OntClass)null, "http://ontobox.org/#string", 0, 1);
            cleaner.addEntity(t1);
            TProperty t2 = this.ont.createTProperty("t2", baseCl, "http://ontobox.org/#string", 0, 1);
            cleaner.addEntity(t2);
            TProperty t3 = this.ont.createTProperty("t3", subCl, "http://ontobox.org/#string", 0, 1);
            cleaner.addEntity(t3);
            TProperty t4 = this.ont.createTProperty("t4", base2Cl, "http://ontobox.org/#string", 0, 1);
            cleaner.addEntity(t4);
            OntObject object1 = this.ont.createOntObject(subCl, base2Cl);
            cleaner.addEntity(object1);
            for (OProperty oprop : object1.getAllOProperties()) {
                properties = object1.getOProperties(oprop.getName());
                OntObjectTestCase.assertTrue((boolean)properties.contains(oprop));
                OntObjectTestCase.assertEquals((int)1, (int)properties.size());
            }
            for (TProperty tprop : object1.getAllTProperties()) {
                properties = object1.getTProperties(tprop.getName());
                OntObjectTestCase.assertTrue((boolean)properties.contains(tprop));
                OntObjectTestCase.assertEquals((int)1, (int)properties.size());
            }
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOnwer() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("cl", new OntClass[0]);
            cleaner.addEntity(cl);
            OProperty prop = this.ont.createOProperty("prop", cl, cl, null, null);
            cleaner.addEntity(prop);
            OntObject v = this.ont.createOntObject(cl);
            cleaner.addEntity(v);
            OntObject owner1 = this.ont.createOntObject(cl);
            cleaner.addEntity(owner1);
            OntObject owner2 = this.ont.createOntObject(cl);
            cleaner.addEntity(owner2);
            OntObject owner3 = this.ont.createOntObject(cl);
            cleaner.addEntity(owner3);
            Collection<OntObject> owners = v.getOwners(prop);
            OntObjectTestCase.assertEquals((int)0, (int)owners.size());
            owner1.addOPropertyValue(prop, v);
            owners = v.getOwners(prop);
            OntObjectTestCase.assertEquals((int)1, (int)owners.size());
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner1));
            owner2.addOPropertyValue(prop, v);
            owners = v.getOwners(prop);
            OntObjectTestCase.assertEquals((int)2, (int)owners.size());
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner1));
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner2));
            owner2.addOPropertyValue(prop, v);
            owners = v.getOwners(prop);
            OntObjectTestCase.assertEquals((int)2, (int)owners.size());
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner1));
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner2));
            owner3.addOPropertyValue(prop, v);
            owners = v.getOwners(prop);
            OntObjectTestCase.assertEquals((int)3, (int)owners.size());
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner1));
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner2));
            OntObjectTestCase.assertTrue((boolean)owners.contains(owner3));
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascade() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("cl1", new OntClass[0]);
            cleaner.addEntity(cl);
            OProperty oprop1 = this.ont.createOProperty("oprop1", null, null, null, null);
            cleaner.addEntity(oprop1);
            OProperty oprop2 = this.ont.createOProperty("oprop2", null, cl, null, null);
            cleaner.addEntity(oprop2);
            OProperty oprop3 = this.ont.createOProperty("oprop3", cl, null, null, null);
            cleaner.addEntity(oprop3);
            oprop1.putAnnotation("http://meta2project.org/model#cascade", "cascade-delete");
            oprop2.putAnnotation("http://meta2project.org/model#cascade", "cascade-delete");
            oprop3.putAnnotation("http://meta2project.org/model#cascade", "cascade-delete");
            OntObject obj = this.ont.createOntObject(cl);
            obj.addOPropertyValue(oprop1, this.ont.createOntObject(new Object[0]));
            obj.addOPropertyValue(oprop1, this.ont.createOntObject(new Object[0]));
            OntObject value = this.ont.createOntObject(cl);
            obj.addOPropertyValue(oprop2, value);
            obj.addOPropertyValue(oprop3, this.ont.createOntObject(cl));
            OntObject obj2 = this.ont.createOntObject(new Object[0]);
            obj2.addOPropertyValue(oprop1, value);
            OntObjectTestCase.assertEquals((int)2, (int)obj.getOPropertyValues(oprop1).size());
            OntObjectTestCase.assertEquals((int)1, (int)obj.getOPropertyValues(oprop2).size());
            OntObjectTestCase.assertEquals((int)1, (int)obj.getOPropertyValues(oprop3).size());
            OntObjectTestCase.assertEquals((int)1, (int)obj2.getOPropertyValues(oprop1).size());
            OntObjectTestCase.assertEquals((int)6, (int)this.ont.getAllOntObjects().size());
            obj.delete();
            OntObjectTestCase.assertEquals((int)1, (int)obj2.getOPropertyValues(oprop1).size());
            OntObjectTestCase.assertEquals((int)2, (int)this.ont.getAllOntObjects().size());
            obj2.delete();
            OntObjectTestCase.assertEquals((int)0, (int)this.ont.getAllOntObjects().size());
        }
        catch (Exception e) {
            System.out.println("!!!!" + e);
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVMap() {
        BoxWorker worker = this.con.getWorker();
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("cl1", new OntClass[0]);
            cleaner.addEntity(cl);
            TProperty tprop1 = this.ont.createTProperty("tprop1", cl, null, null, null);
            cleaner.addEntity(tprop1);
            OProperty oprop1 = this.ont.createOProperty("oprop1", cl, null, null, null);
            cleaner.addEntity(oprop1);
            OntObject obj = this.ont.createOntObject(cl);
            cleaner.addEntity(obj);
            VMap map = new VMap(worker, worker.id(obj.getFullName()));
            OntObjectTestCase.assertEquals((int)2, (int)map.size());
            OntObjectTestCase.assertFalse((boolean)map.isEmpty());
            OntObjectTestCase.assertTrue((boolean)map.containsKey(tprop1.getFullName()));
            OntObjectTestCase.assertTrue((boolean)map.containsKey(oprop1.getFullName()));
            OntObjectTestCase.assertTrue((boolean)map.keySet().contains(tprop1.getFullName()));
            OntObjectTestCase.assertTrue((boolean)map.keySet().contains(oprop1.getFullName()));
            OntObjectTestCase.assertNull((Object)map.get(tprop1.getFullName()).string());
            OntObjectTestCase.assertTrue((boolean)map.get(tprop1.getFullName()).strings().isEmpty());
            OntObjectTestCase.assertNull((Object)map.get(oprop1.getFullName()).object());
            OntObjectTestCase.assertTrue((boolean)map.get(oprop1.getFullName()).objects().isEmpty());
            obj.addTPropertyString(tprop1, "vvv");
            OntObjectTestCase.assertEquals((String)"vvv", (String)map.get(tprop1.getFullName()).string());
            OntObject obj2 = this.ont.createOntObject(cl);
            cleaner.addEntity(obj2);
            obj2.addTPropertyString(tprop1, "zzz");
            try {
                obj.addOPropertyValue(oprop1, obj2);
                OntObjectTestCase.assertEquals((String)"zzz", (String)map.get(oprop1.getFullName()).map().get(tprop1.getFullName()).string());
                OntObjectTestCase.assertEquals((String)"zzz", (String)map.mMap(oprop1.getFullName()).mString(tprop1.getFullName()));
                OntObjectTestCase.assertEquals((int)worker.id(obj2.getFullName()), (int)map.get(oprop1.getFullName()).map().id());
                OntObjectTestCase.assertEquals((int)worker.id(obj2.getFullName()), (int)map.mMap(oprop1.getFullName()).id());
                OntObjectTestCase.assertEquals((String)obj2.getFullName(), (String)map.get(oprop1.getFullName()).map().name());
                OntObjectTestCase.assertEquals((String)obj2.getFullName(), (String)map.mMap(oprop1.getFullName()).name());
            }
            finally {
                obj.removeAllValues();
            }
        }
        finally {
            cleaner.cleanup();
        }
        WorkerCleaner cleaner2 = new WorkerCleaner(worker);
        try {
            int m = MapHelper.create(worker);
            cleaner2.add(m);
            worker.write().addString(m, MapHelper.tkey(worker, m, "t1"), "1");
            worker.write().addString(m, MapHelper.tkey(worker, m, "t2"), "2");
            VMap map = new VMap(worker, m);
            OntObjectTestCase.assertEquals((int)2, (int)map.size());
            OntObjectTestCase.assertFalse((boolean)map.isEmpty());
            OntObjectTestCase.assertTrue((boolean)map.containsKey("t1"));
            OntObjectTestCase.assertTrue((boolean)map.containsKey(worker.name(MapHelper.tkey(worker, m, "t1"))));
            OntObjectTestCase.assertTrue((boolean)map.containsKey("t2"));
            OntObjectTestCase.assertTrue((boolean)map.containsKey(worker.name(MapHelper.tkey(worker, m, "t2"))));
            OntObjectTestCase.assertTrue((boolean)map.keySet().contains("t1"));
            OntObjectTestCase.assertTrue((boolean)map.keySet().contains("t2"));
            OntObjectTestCase.assertEquals((String)"1", (String)map.get("t1").string());
            OntObjectTestCase.assertEquals((String)"1", (String)map.get(worker.name(MapHelper.tkey(worker, m, "t1"))).string());
            OntObjectTestCase.assertEquals((String)"2", (String)map.get("t2").string());
            OntObjectTestCase.assertEquals((String)"2", (String)map.get(worker.name(MapHelper.tkey(worker, m, "t2"))).string());
            QContext c = new QContext();
            c.setDefaultPrefix(this.ont.getURI());
            Query q = c.createQuery("*[@t1==?];");
            q.setString(0, "1");
            List<Integer> objects = worker.qObjects(c, q);
            for (Integer object : objects) {
                System.out.println("Object id: " + object);
            }
            List<String> strings = worker.qStrings(c, q);
            for (String string : strings) {
                System.out.println("Object full name: " + string);
            }
            strings = worker.qStrings(c, "*/@t1;");
            for (String string : strings) {
                System.out.println("Value: " + string);
            }
            VMap vmap = worker.qMap(c, "&&_ { @test1 = 'aaa'; @test2 = 'bbb'}");
            System.out.println(vmap.get("test1").string());
            System.out.println(vmap.mString("test1"));
            System.out.println(vmap.get("test2").string());
            System.out.println(vmap.mString("test2"));
            c.setDefaultPrefix(worker.name(worker.ontology(m)));
            String qstr = "123; &" + worker.local(m) + ";";
            map = worker.qMap(c, qstr);
            System.out.println(qstr + ", t1=" + map.mString("t1"));
            System.out.println(qstr + ", t2=" + map.mString("t2"));
            q = c.createQuery("?;");
            q.setObject(0, m);
            System.out.println(worker.qString(c, q));
            q.setObject(0, worker.name(m));
            System.out.println(worker.qString(c, q));
            q.setObj(0, worker.local(m));
            System.out.println(worker.qString(c, q));
            System.out.println("Map: " + worker.qString(c, "map:Map;"));
            System.out.println("Map-aaa: " + worker.qString(c, "map:Map[test1='aaa'];"));
            System.out.println("Map-ccc: " + worker.qString(c, "map:Map[test1='ccc'];"));
            q = c.createQuery("map:Map[test1=?];");
            q.setString(0, "aaa");
            System.out.println("Map-aaa: " + worker.qString(c, q));
            q.setString(0, "ccc");
            System.out.println("Map-ccc: " + worker.qString(c, q));
            QContext ctx = new QContext();
            ctx.setDefaultPrefix(this.ont.getURI());
            ctx.setPrefix("m", worker.name(worker.ontology(m)));
            map = worker.qMap(ctx, "123; &m:" + worker.local(m) + ";");
            System.out.println(map.mString("t1"));
            System.out.println(map.mString("t2"));
            List<VMap> maps = worker.qMaps(ctx, "*");
            for (VMap vMap : maps) {
                System.out.println(vMap.keySet());
            }
            maps = worker.qMaps(ctx, ctx.createQuery("*"));
            for (VMap vMap : maps) {
                System.out.println(vMap.keySet());
            }
            Values values = worker.qValues(ctx, "*");
            for (String s : values.strings()) {
                System.out.println(s);
            }
            for (String s : worker.qStrings(ctx, "*")) {
                System.out.println(s);
            }
            values = worker.qValues(ctx, ctx.createQuery("*"));
            for (String s : values.strings()) {
                System.out.println(s);
            }
            values = worker.qValues(ctx, "*/@t1");
            for (String s : values.strings()) {
                System.out.println(s);
            }
            values = worker.qValues(ctx, ctx.createQuery("*/@t1"));
            for (String s : values.strings()) {
                System.out.println(s);
            }
            for (String s : worker.qStrings(ctx, ctx.createQuery("*/@t1"))) {
                System.out.println(s);
            }
            for (String s : worker.qStrings(ctx, "*[@t1='1'];")) {
                System.out.println(s);
            }
            Query q2 = ctx.createQuery("*[@t1=?];");
            q2.setString(0, "1");
            for (String s : worker.qStrings(ctx, q2)) {
                System.out.println(s);
            }
        }
        finally {
            cleaner2.cleanup();
            TempHelper.cleanUp(worker);
        }
    }
}

