/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client;

import com.teacode.bml.BML;
import com.teacode.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.meta2project.ontobox.client.ClientResult;
import org.meta2project.ontobox.client.CounterInputStream;
import org.meta2project.ontobox.client.ResponseException;

public class Client {
    private static final String ENCODING = "UTF-8";
    private final URL url;
    private final String au;
    private final boolean useGZip;

    public Client(URL url, String login, String password, boolean gzip) throws UnsupportedEncodingException {
        this.url = url;
        this.useGZip = gzip;
        this.au = "Basic " + Base64.encodeBytes((byte[])(login + ':' + password).getBytes("ASCII"));
    }

    public final ClientResult query(String query) throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.url.openConnection();
        try {
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestProperty("Authorization", this.au);
            if (this.useGZip) {
                con.setRequestProperty("Accept-Encoding", "gzip");
            }
            String postData = URLEncoder.encode("query", ENCODING) + '=' + URLEncoder.encode(query, ENCODING);
            OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream());
            writer.write(postData);
            writer.flush();
            CounterInputStream counterInputStream = new CounterInputStream(con.getInputStream());
            String mimeType = con.getContentType();
            if (mimeType == null) {
                throw new IOException("response MIME type is null");
            }
            if (!mimeType.equals("application/x-bml")) {
                throw new IOException("unsupported response MIME type (" + mimeType + ')');
            }
            String encoding = con.getHeaderField("Content-Encoding");
            boolean gzip = encoding != null && encoding.equalsIgnoreCase("gzip");
            InputStream in = gzip ? new GZIPInputStream(counterInputStream) : counterInputStream;
            Map data = (Map)BML.load((InputStream)in);
            ClientResult clientResult = new ClientResult((String)data.get("query"), (String)data.get("error"), (Collection)data.get("result"), (Map)data.get("ns"), (Long)data.get("raw-time"), counterInputStream.getLoaded(), gzip);
            return clientResult;
        }
        catch (Exception e) {
            int code = con.getResponseCode();
            if (code != -1 && code != 200) {
                throw new ResponseException(code, con.getResponseMessage(), e);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            con.disconnect();
        }
    }
}

