/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client.example;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.meta2project.ontobox.client.Client;
import org.meta2project.ontobox.client.ClientResult;

public class ClientExample {
    protected static void executeAndPrintResult(Client client, String query) throws IOException {
        ClientResult result = client.query(query);
        if (result.getError() != null) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430: " + result.getError() + " \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 " + query);
        } else {
            System.out.println("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 " + query);
            System.out.println("\u0414\u043b\u0438\u043d\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 (\u0432 \u0431\u0430\u0439\u0442\u0430\u0445): " + result.getReadBytes());
            if (result.getRawTime() != null) {
                System.out.println("\u0412\u0440\u0435\u043c\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 (\u043c\u0441): " + result.getRawTime());
            }
            System.out.println();
            for (Collection<String> collection : result.getResult()) {
                boolean first = true;
                for (String s : collection) {
                    if (first) {
                        first = false;
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(s);
                }
                System.out.println();
            }
            System.out.println();
            Map<String, String> map = result.getMapping();
            ArrayList<String> prefixes = new ArrayList<String>(map.keySet());
            Collections.sort(prefixes);
            for (String prefix : prefixes) {
                System.out.println(prefix + ": " + map.get(prefix));
            }
        }
    }

    public static void main(String[] args) throws IOException {
        Client client = new Client(new URL("http://server.meta2project.org/server/m2p"), "stel", "stel", false);
        ClientExample.executeAndPrintResult(client, "*:*/count(); *:*");
        ClientExample.executeAndPrintResult(client, "asdf");
    }
}

