/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.server;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.meta2project.fast.adapter.FastSession;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.Session;
import org.meta2project.model.TProperty;
import org.meta2project.ontobox.server.HttpErrorException;
import org.meta2project.ontobox.server.UserContext;
import org.ontobox.exchange.MVX;

public class ServerManager {
    private static final Logger logger = Logger.getLogger(ServerManager.class.getName());
    private static final String KEY = "org.meta2project.ontobox.servermanager";
    private final File baseDir;
    private final Session adminSession;
    private final Map<String, Map<String, UserContext>> context = new HashMap<String, Map<String, UserContext>>(100);
    private final Map<String, Session> resources = new HashMap<String, Session>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerManager(String realPath) throws Exception {
        this.baseDir = new File(realPath, "WEB-INF");
        this.adminSession = new FastSession();
        Connection con = this.adminSession.openConnection();
        try {
            MVX.importUnpackedFile(new File(new File(this.baseDir, "admin"), "admin.xml"), con.getWorker());
        }
        finally {
            con.close();
        }
    }

    private Session getResource(String base) {
        Session ret = this.resources.get(base);
        if (ret == null) {
            File d = new File(new File(this.baseDir, "data"), base);
            if (!d.exists() || !d.isDirectory()) {
                throw new HttpErrorException(404);
            }
            ret = new FastSession(d);
            this.resources.put(base, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserContext getUserContext(String login, String password, String base) throws HttpErrorException {
        Connection con = this.adminSession.openConnection();
        try {
            UserContext ret;
            Ontology ont = con.getOntology("http://meta2project.org/server/admin");
            TProperty loginProp = ont.getTProperty("login");
            TProperty passwordProp = ont.getTProperty("password");
            OProperty resProp = ont.getOProperty("resources");
            OntClass users = ont.getOntClass("User");
            OntObject user = null;
            for (OntObject u : users.getAllOntObjects()) {
                if (!login.equals(u.getTPropertyString(loginProp))) continue;
                user = u;
                break;
            }
            if (user == null) {
                throw new HttpErrorException(401);
            }
            if (!password.equals(user.getTPropertyString(passwordProp))) {
                throw new HttpErrorException(401);
            }
            OntClass resources = ont.getOntClass("Resource");
            TProperty nameProp = ont.getTProperty("name");
            OntObject resource = null;
            for (OntObject r : resources.getAllOntObjects()) {
                if (!base.equals(r.getTPropertyString(nameProp))) continue;
                resource = r;
                break;
            }
            if (resource == null) {
                throw new HttpErrorException(404);
            }
            if (!user.getOPropertyValues(resProp).contains(resource)) {
                throw new HttpErrorException(403);
            }
            Map<String, UserContext> c = this.context.get(login);
            if (c == null) {
                c = new HashMap<String, UserContext>();
                this.context.put(login, c);
            }
            if ((ret = c.get(base)) == null) {
                ret = new UserContext(this.getResource(base));
                c.put(base, ret);
            }
            UserContext userContext = ret;
            return userContext;
        }
        finally {
            con.close();
        }
    }

    private void close() {
        logger.info("Closing admin session");
        this.adminSession.close();
        for (Session session : this.resources.values()) {
            logger.info("Closing session " + session);
            session.close();
        }
    }

    public static ServerManager getInstance(ServletContext app) throws Exception {
        ServerManager manager = (ServerManager)app.getAttribute(KEY);
        if (manager == null) {
            String realPath = app.getRealPath("/");
            if (realPath == null) {
                realPath = System.getProperty("user.dir");
            }
            manager = new ServerManager(realPath);
            app.setAttribute(KEY, (Object)manager);
        }
        return manager;
    }

    public static void close(ServletContext app) {
        logger.info("Closing");
        ServerManager manager = (ServerManager)app.getAttribute(KEY);
        logger.info("Manager=" + manager);
        if (manager != null) {
            manager.close();
        }
    }
}

