/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.owlapi;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyManager;

public class OWLAPI {
    private static void addSubClass(OWLOntologyManager manager, OWLOntology ontology, OWLDataFactory factory, OntClass subClass, OntClass superClass) throws Exception {
        OWLClass subCl = factory.getOWLClass(URI.create(subClass.getFullName()));
        OWLClass superCl = OWLAPI.getOWLClass(factory, superClass);
        manager.addAxiom(ontology, (OWLAxiom)factory.getOWLSubClassAxiom((OWLDescription)subCl, (OWLDescription)superCl));
    }

    private static OWLClass getOWLClass(OWLDataFactory factory, OntClass cl) {
        if (cl == null) {
            return factory.getOWLThing();
        }
        return factory.getOWLClass(OWLAPI.uri(cl));
    }

    private static void addAnnotations(OWLOntologyManager manager, OWLOntology ontology, OWLDataFactory factory, NamedEntity ae) throws Exception {
        String comment;
        OWLClass entity;
        if (ae instanceof OntClass) {
            entity = factory.getOWLClass(OWLAPI.uri(ae));
        } else if (ae instanceof OntObject) {
            entity = factory.getOWLIndividual(OWLAPI.uri(ae));
        } else if (ae instanceof TProperty) {
            entity = factory.getOWLDataProperty(OWLAPI.uri(ae));
        } else if (ae instanceof OProperty) {
            entity = factory.getOWLObjectProperty(OWLAPI.uri(ae));
        } else if (ae instanceof Type) {
            entity = factory.getOWLDataType(OWLAPI.uri(ae));
        } else {
            return;
        }
        String title = ae.getAnnotation("http://meta2project.org/model#title");
        if (title != null) {
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLEntityAnnotationAxiom((OWLEntity)entity, (OWLAnnotation)factory.getOWLLabelAnnotation(title)));
        }
        if ((comment = ae.getAnnotation("http://meta2project.org/model#comment")) != null) {
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLEntityAnnotationAxiom((OWLEntity)entity, (OWLAnnotation)factory.getCommentAnnotation(comment)));
        }
    }

    private static void addAnnotations(OWLOntologyManager manager, OWLOntology ontology, OWLDataFactory factory, Ontology ont) throws Exception {
        String comment;
        String title = ont.getAnnotation("http://meta2project.org/model#title");
        if (title != null) {
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLOntologyAnnotationAxiom(ontology, (OWLAnnotation)factory.getOWLLabelAnnotation(title)));
        }
        if ((comment = ont.getAnnotation("http://meta2project.org/model#comment")) != null) {
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLOntologyAnnotationAxiom(ontology, (OWLAnnotation)factory.getCommentAnnotation(comment)));
        }
    }

    private static OWLOntology convertOntology(OWLOntologyManager manager, OWLDataFactory factory, Ontology ont) throws Exception {
        OWLOntology ontology = manager.createOntology(URI.create(ont.getURI()));
        OWLAPI.addAnnotations(manager, ontology, factory, ont);
        for (OntClass ontClass : ont.getOntClasses()) {
            Collection<OntClass> superClasses = ontClass.getSuperClasses();
            if (superClasses.isEmpty()) {
                OWLAPI.addSubClass(manager, ontology, factory, ontClass, null);
            } else {
                for (OntClass superClass : superClasses) {
                    OWLAPI.addSubClass(manager, ontology, factory, ontClass, superClass);
                }
            }
            OWLAPI.addAnnotations(manager, ontology, factory, ontClass);
        }
        for (TProperty tprop : ont.getAllTProperties()) {
            OWLDataProperty dataProperty = factory.getOWLDataProperty(OWLAPI.uri(tprop));
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)dataProperty, (OWLDescription)OWLAPI.getOWLClass(factory, tprop.getDomain())));
            Type type = tprop.getRange();
            if (type != null) {
                OWLDataType range = factory.getOWLDataType(URI.create(type.getFullName()));
                manager.addAxiom(ontology, (OWLAxiom)factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)dataProperty, (OWLDataRange)range));
            }
            OWLAPI.addAnnotations(manager, ontology, factory, tprop);
        }
        for (OProperty oprop : ont.getAllOProperties()) {
            OWLObjectProperty objectProperty = factory.getOWLObjectProperty(OWLAPI.uri(oprop));
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)objectProperty, (OWLDescription)OWLAPI.getOWLClass(factory, oprop.getDomain())));
            manager.addAxiom(ontology, (OWLAxiom)factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)objectProperty, (OWLDescription)OWLAPI.getOWLClass(factory, oprop.getRange())));
            OWLAPI.addAnnotations(manager, ontology, factory, oprop);
        }
        for (OntObject object : ont.getAllOntObjects()) {
            OWLIndividual ind = factory.getOWLIndividual(OWLAPI.uri(object));
            Collection<OntClass> classes = object.getOntClasses();
            if (classes.isEmpty()) {
                manager.addAxiom(ontology, (OWLAxiom)factory.getOWLClassAssertionAxiom(ind, (OWLDescription)OWLAPI.getOWLClass(factory, null)));
            } else {
                for (OntClass cl : classes) {
                    manager.addAxiom(ontology, (OWLAxiom)factory.getOWLClassAssertionAxiom(ind, (OWLDescription)OWLAPI.getOWLClass(factory, cl)));
                }
            }
            for (OProperty oprop : object.getAllOProperties()) {
                OWLObjectProperty objectProperty = factory.getOWLObjectProperty(OWLAPI.uri(oprop));
                for (OntObject ontObject : object.getOPropertyValues(oprop)) {
                    if (ontObject == null) continue;
                    manager.addAxiom(ontology, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom(ind, (OWLObjectPropertyExpression)objectProperty, factory.getOWLIndividual(OWLAPI.uri(ontObject))));
                }
            }
            for (TProperty tprop : object.getAllTProperties()) {
                OWLDataProperty dataProperty = factory.getOWLDataProperty(OWLAPI.uri(tprop));
                for (String string : object.getTPropertyStrings(tprop)) {
                    if (string == null) continue;
                    Type range = tprop.getRange();
                    Object v = range != null ? factory.getOWLTypedConstant(string, factory.getOWLDataType(OWLAPI.uri(range))) : factory.getOWLUntypedConstant(string);
                    manager.addAxiom(ontology, (OWLAxiom)factory.getOWLDataPropertyAssertionAxiom(ind, (OWLDataPropertyExpression)dataProperty, (OWLConstant)v));
                }
            }
            OWLAPI.addAnnotations(manager, ontology, factory, object);
        }
        return ontology;
    }

    public static void createRDFOWL(Ontology ont, File file) throws Exception {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = OWLAPI.convertOntology(manager, factory, ont);
        manager.saveOntology(ontology, file.toURI());
    }

    public static void createFSyntax(Ontology ont, File file) throws Exception {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = OWLAPI.convertOntology(manager, factory, ont);
        manager.saveOntology(ontology, (OWLOntologyFormat)new OWLFunctionalSyntaxOntologyFormat(), file.toURI());
    }

    private static URI uri(NamedEntity ne) {
        return URI.create(ne.getFullName());
    }
}

