/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.base;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.RequireManager;
import org.ontobox.exchange.MVX;
import org.ontobox.exchange.mvx.Ontologies;
import org.ontobox.exchange.mvx.OntologyProcessor;

public class BaseRequireManager
implements RequireManager {
    private static final Logger logger = Logger.getLogger(BaseRequireManager.class.getName());
    private final String baseURI;
    private final Set<String> exception;
    private final RequireManager parentManager;

    public BaseRequireManager(String baseURI, RequireManager parentManager, String ... exc) {
        this.baseURI = baseURI;
        this.parentManager = parentManager;
        this.exception = new HashSet<String>(Arrays.asList(exc));
    }

    public static String sha(String uri) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA");
            m.update(uri.getBytes("UTF-8"));
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadRemote(BoxWorker worker, final RequireManager.SubRequireLoader loader, final String uri) {
        if (this.exception.contains(uri)) {
            return false;
        }
        String localName = BaseRequireManager.sha(uri) + ".mvx";
        String remoteName = this.baseURI + localName;
        File dir = new File(System.getProperty("user.home"), ".ontobox-repo");
        dir.mkdirs();
        File localFile = new File(dir, localName);
        try {
            logger.info("Loading required " + uri + " from " + remoteName);
            InputStream in = new URL(remoteName).openStream();
            try {
                FileOutputStream out = new FileOutputStream(localFile);
                try {
                    int read;
                    byte[] buf = new byte[10000];
                    while ((read = in.read(buf)) != -1) {
                        ((OutputStream)out).write(buf, 0, read);
                    }
                }
                finally {
                    ((OutputStream)out).close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (Exception e) {
            logger.warning("Loading required " + uri + " failed: " + e);
        }
        if (!localFile.exists()) {
            return false;
        }
        logger.info("Using " + localFile + " for " + uri);
        try {
            Ontologies list = MVX.ontologies(localFile);
            List<String> onts = list.ontologies();
            if (onts.size() != 1) {
                throw new IllegalStateException("RepoMVX must contain only one ontology (" + onts.size() + " actually, " + remoteName + ")");
            }
            if (!uri.equals(onts.get(0))) {
                throw new IllegalStateException("RepoMVX must contain " + uri + " ontology (" + onts.get(0) + " actually, " + remoteName + ")");
            }
            MVX.importFile(localFile, worker, new OntologyProcessor(){

                @Override
                public void loadRequired(BoxWorker worker, String u) {
                    loader.require(u);
                }

                @Override
                public void preloadOntology(BoxWorker worker, String u) {
                    if (!uri.equals(u)) {
                        throw new IllegalStateException("Strange ontology " + u);
                    }
                }
            });
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean loadRequired(BoxWorker worker, RequireManager.SubRequireLoader loader, String uri) {
        return this.loadRemote(worker, loader, uri) || this.parentManager != null && this.parentManager.loadRequired(worker, loader, uri);
    }
}

