/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntSet;
import java.math.BigInteger;
import java.security.MessageDigest;
import org.ontobox.box.BoxWorker;

public class OntologyHelper {
    public static String sha(String uri) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA");
            m.update(uri.getBytes("UTF-8"));
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] getUsedOntologies(BoxWorker worker, int ont) {
        Integer domain;
        IntSet onts = CCreator.newIntSet((int)10);
        for (int cl : worker.classes(ont)) {
            for (int superCl : worker.classesDirect(cl)) {
                onts.add(worker.ontology(superCl));
            }
        }
        for (int tprop : worker.tprops(ont)) {
            Integer range;
            domain = worker.domain(tprop);
            if (domain != null) {
                onts.add(worker.ontology(domain));
            }
            if ((range = worker.range(tprop)) == null) continue;
            onts.add(worker.ontology(range));
        }
        for (int oprop : worker.oprops(ont)) {
            Integer range;
            domain = worker.domain(oprop);
            if (domain != null) {
                onts.add(worker.ontology(domain));
            }
            if ((range = worker.range(oprop)) == null) continue;
            onts.add(worker.ontology(range));
        }
        for (int obj : worker.objects(ont)) {
            for (int cl : worker.classesDirect(obj)) {
                onts.add(worker.ontology(cl));
            }
            for (int tprop : worker.tprops(obj)) {
                onts.add(worker.ontology(tprop));
            }
            for (int oprop : worker.oprops(obj)) {
                onts.add(worker.ontology(oprop));
                for (int v : worker.objects(obj, oprop)) {
                    onts.add(worker.ontology(v));
                }
            }
        }
        onts.removeValue(ont);
        return onts.toArray();
    }
}

