/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.RHelper;

public class Searcher {
    private static void searchSubstring(BoxWorker worker, String value, IntSet owners) {
        String lowValue = value.toLowerCase();
        for (int ontId : worker.ontologies()) {
            for (int tpropId : worker.tprops(ontId)) {
                for (String fullValue : worker.strings(tpropId)) {
                    if (!fullValue.toLowerCase().contains(lowValue)) continue;
                    owners.addAll(worker.owners(tpropId, fullValue));
                }
            }
        }
    }

    public static SearchContext findBySubstring(BoxWorker worker, String value) {
        IntSet owners = CCreator.newIntSet((int)10);
        Searcher.searchSubstring(worker, value, owners);
        return new SearchContext(worker, owners.toArray());
    }

    public static SearchContext findByString(BoxWorker worker, String prop, String value) {
        return new SearchContext(worker, worker.owners(worker.resolve(prop), value));
    }

    public static SearchContext findByInteger(BoxWorker worker, String prop, int value) {
        return new SearchContext(worker, worker.owners(worker.resolve(prop), String.valueOf(value)));
    }

    public static SearchContext findByLong(BoxWorker worker, String prop, long value) {
        return new SearchContext(worker, worker.owners(worker.resolve(prop), String.valueOf(value)));
    }

    public static SearchContext findByObject(BoxWorker worker, String prop, int value) {
        return new SearchContext(worker, worker.owners(worker.resolve(prop), value));
    }

    public static class SearchContext {
        private final BoxWorker worker;
        private final int[] res;

        public SearchContext(BoxWorker worker, int[] res) {
            this.worker = worker;
            this.res = res;
        }

        public SearchContext andBySubstring(String value) {
            IntSet newOwners = CCreator.newIntSet((int)10);
            Searcher.searchSubstring(this.worker, value, newOwners);
            IntSet ret = CCreator.newIntSet((int)10);
            for (int obj : this.res) {
                if (!newOwners.contains(obj)) continue;
                ret.add(obj);
            }
            return new SearchContext(this.worker, ret.toArray());
        }

        public SearchContext orBySubstring(String value) {
            IntSet owners = CCreator.newIntSet((int)10);
            owners.addAll(this.res);
            Searcher.searchSubstring(this.worker, value, owners);
            return new SearchContext(this.worker, owners.toArray());
        }

        public SearchContext andByString(String prop, String value) {
            int propId = this.worker.resolve(prop);
            IntList ret = CCreator.newIntList((int)16);
            for (int re : this.res) {
                if (!RHelper.contains(this.worker.strings(re, propId), value)) continue;
                ret.add(re);
            }
            return new SearchContext(this.worker, ret.toArray());
        }

        public SearchContext andByInteger(String prop, int value) {
            return this.andByString(prop, String.valueOf(value));
        }

        public SearchContext andByObject(String prop, int value) {
            int propId = this.worker.resolve(prop);
            IntList ret = CCreator.newIntList((int)16);
            for (int re : this.res) {
                if (!RHelper.contains(this.worker.objects(re, propId), value)) continue;
                ret.add(re);
            }
            return new SearchContext(this.worker, ret.toArray());
        }

        public int[] all() {
            return this.res;
        }

        public Integer single() {
            int len = this.res.length;
            if (len == 0) {
                return null;
            }
            if (len > 1) {
                throw new IllegalArgumentException("Too many results");
            }
            return this.res[0];
        }
    }
}

