/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.query;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.exception.IllegalNameException;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;
import org.ontobox.box.helper.Values;
import org.ontobox.box.query.FunctionInfo;
import org.ontobox.box.query.Query;
import org.ontobox.box.query.QueryValues;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.VarTable;

public class QContext {
    private static final Pattern POSITION_PATTERN = Pattern.compile("\\[(\\d+):(\\d+)\\]");
    private final Handler handler;
    private VarTable vars = null;

    public QContext() {
        this.handler = new Handler();
    }

    public QContext(QContext ctx) {
        this.handler = new Handler(ctx.handler);
    }

    public synchronized void setPrefix(String prefix, String uri) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        this.handler.getMapping().put(prefix, uri);
    }

    public synchronized void setDefaultPrefix(String uri) {
        this.setPrefix("", uri);
    }

    public synchronized Map<String, String> getPrefixes() {
        return Collections.unmodifiableMap(this.handler.getMapping());
    }

    public void setPrintWriter(PrintWriter writer) {
        this.handler.setPrintWriter(writer);
    }

    public PrintWriter getPrintWriter() {
        return this.handler.getPrintWriter();
    }

    public String unshortenName(String prefixedName) {
        String name;
        String uri;
        int colon = prefixedName.indexOf(58);
        if (colon == -1) {
            uri = this.handler.getMapping().get("");
            if (uri == null) {
                throw new IllegalNameException("Default ontology prefix is not defined (" + prefixedName + ")");
            }
            name = prefixedName;
        } else {
            String prefix = prefixedName.substring(0, colon);
            uri = this.handler.getMapping().get(prefix);
            if (uri == null) {
                throw new IllegalNameException("Prefix " + prefix + " is not defined (" + prefixedName + ")");
            }
            name = prefixedName.substring(colon + 1);
        }
        if (name.isEmpty()) {
            throw new IllegalNameException("Local name is empty (" + prefixedName + ")");
        }
        if (name.indexOf(58) != -1) {
            throw new IllegalNameException("Local name contains ':' symbol (" + prefixedName + ")");
        }
        return uri + "#" + name;
    }

    public String shortName(String fullName) {
        SplittedName sn = NameHelper.splitName(fullName);
        String prefix = null;
        if (sn.ontology().equals(this.handler.getMapping().get(""))) {
            prefix = "";
        } else {
            for (Map.Entry<String, String> entry : this.handler.getMapping().entrySet()) {
                if (!entry.getValue().equals(sn.ontology())) continue;
                prefix = entry.getKey() + ":";
                break;
            }
        }
        if (prefix == null) {
            return null;
        }
        return prefix + sn.local();
    }

    public List<FunctionInfo> getFunctions(BoxWorker worker, String uri) {
        ArrayList<FunctionInfo> ret = new ArrayList<FunctionInfo>();
        uri = uri + "#";
        FunctionTable functions = this.handler.getFunctions();
        int size = functions.howManyNames();
        for (int t = 0; t < size; ++t) {
            FunctionDef def;
            String name = functions.getName(t);
            if (!name.startsWith(uri) || (def = functions.getDefinition(t)) == null) continue;
            ret.add(new FunctionInfo(worker, def));
        }
        return ret;
    }

    public synchronized Query createQuery(String query) {
        return new Query(this, query);
    }

    public synchronized void setGlobalVarMode(boolean mode) {
        if (mode) {
            if (this.vars == null) {
                this.vars = new VarTable();
            }
        } else {
            this.vars = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collection> execute(BoxWorker worker, String query) {
        VarTable v;
        QContext qContext = this;
        synchronized (qContext) {
            v = this.vars;
            if (v == null) {
                v = new VarTable();
            }
        }
        return this.handler.execute(new LocalContext(this.handler, worker, v), query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Collection> execute(BoxWorker worker, Query q) {
        VarTable v;
        QContext qContext = this;
        synchronized (qContext) {
            v = this.vars;
            if (v == null) {
                v = new VarTable();
            }
        }
        LocalContext lc = new LocalContext(this.handler, worker, v);
        return this.handler.execute(lc, q.generate(lc));
    }

    public Values getGlobalVar(BoxWorker worker, String name) {
        if (this.vars == null) {
            throw new IllegalStateException("Variable values are available only at the GlobalVarMode");
        }
        try {
            return new QueryValues(worker, (OntCollection)this.vars.getVarValue(this.vars.checkVar(name)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Values> convertListValues(BoxWorker worker, Collection<Collection> res) {
        ArrayList<Values> ret = new ArrayList<Values>(res.size());
        for (Collection r : res) {
            ret.add(new QueryValues(worker, (OntCollection)r));
        }
        return ret;
    }

    public static Values convertValues(BoxWorker worker, Collection<Collection> res) {
        int size = res.size();
        int n = 0;
        for (Collection r : res) {
            if (++n != size) continue;
            return new QueryValues(worker, (OntCollection)r);
        }
        return new QueryValues(worker, null);
    }

    public static void detectError(Exception e, ErrorProcessor processor) {
        QContext.verifyErrorLine1(e, processor);
        QContext.verifyErrorLine2(e, processor);
    }

    protected static void verifyErrorLine1(Exception e, ErrorProcessor processor) {
        Matcher versionMatcher;
        String s = e.getMessage();
        int i = s.lastIndexOf(91);
        if (i != -1 && (i = (s = s.substring(0, i)).lastIndexOf(91)) != -1 && (versionMatcher = POSITION_PATTERN.matcher(s = s.substring(i))).find()) {
            processor.errorDetected(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)));
        }
    }

    protected static void verifyErrorLine2(Exception e, ErrorProcessor processor) {
        Matcher versionMatcher;
        String s = e.getMessage();
        int i = s.lastIndexOf(40);
        if (i != -1 && (versionMatcher = POSITION_PATTERN.matcher(s = s.substring(i))).find()) {
            processor.errorDetected(Integer.parseInt(versionMatcher.group(1)), Integer.parseInt(versionMatcher.group(2)));
        }
    }

    public static interface ErrorProcessor {
        public void errorDetected(int var1, int var2);
    }
}

