/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange.mvx;

import com.teacode.util.Base64;
import com.teacode.util.StringCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.ProgressListener;
import org.ontobox.exchange.TypeMap;
import org.ontobox.exchange.mvx.N;
import org.ontobox.exchange.mvx.Ontologies;
import org.ontobox.exchange.mvx.OntologyProcessor;
import org.ontobox.exchange.mvx.xml.XMLPullParser;

public class MVXLoader {
    private static final Logger logger = Logger.getLogger(MVXLoader.class.getName());

    private static void unknownTag(String name) {
        logger.warning("unknown tag: " + name);
    }

    public static void loadBackupStep1(InputStream in, BoxWorker worker, Map<String, String> project, ProgressListener listener, OntologyProcessor ontologyProcessor) {
        XMLPullParser xpp;
        logger.info("step1");
        try {
            xpp = new XMLPullParser(in);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        try {
            String tag;
            xpp.startTag("ontobase", "ontobox");
            while ((tag = xpp.startAnyTag("ontobase", "ontobox")) != null) {
                if (tag.equals("ontology")) {
                    MVXLoader.startOntologyStep1(xpp, worker, listener, ontologyProcessor);
                    continue;
                }
                if (tag.equals("require")) {
                    MVXLoader.loadRequire(xpp, worker, ontologyProcessor);
                    continue;
                }
                if (tag.equals("annotations")) {
                    MVXLoader.loadAnnoAll(xpp, project, tag);
                    continue;
                }
                MVXLoader.unknownTag(tag);
                xpp.endTag(tag);
            }
        }
        catch (Exception e) {
            throw new ParseException(e, xpp);
        }
    }

    public static void ontologies(InputStream in, Ontologies ret) {
        XMLPullParser xpp;
        logger.info("extracting ontology info");
        try {
            xpp = new XMLPullParser(in);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        try {
            String tag;
            xpp.startTag("ontobase", "ontobox");
            while ((tag = xpp.startAnyTag("ontobase", "ontobox")) != null) {
                if (tag.equals("ontology")) {
                    ret.ontologies().add(xpp.getAttribute("uri"));
                } else if (tag.equals("require")) {
                    ret.requires().add(xpp.getAttribute("uri"));
                }
                xpp.endTag(tag);
            }
        }
        catch (Exception e) {
            throw new ParseException(e, xpp);
        }
    }

    private static String getValue(XMLPullParser xpp) throws IOException {
        String b64 = xpp.getAttribute("base64", null);
        if (b64 != null) {
            return new String(Base64.decode((String)b64), "UTF-8");
        }
        return xpp.getAttribute("value", null);
    }

    private static void loadRequire(XMLPullParser xpp, BoxWorker worker, OntologyProcessor ontologyProcessor) throws Exception {
        ontologyProcessor.loadRequired(worker, xpp.getAttribute("uri"));
        xpp.endTag("require");
    }

    private static void loadAnno(XMLPullParser xpp, Map<String, String> anno) throws Exception {
        String name = xpp.getAttribute("name");
        String v = MVXLoader.getValue(xpp);
        if (v == null) {
            logger.warning("skipped null value of annotation " + name);
        } else {
            anno.put(name, v);
        }
    }

    private static void loadAnno(XMLPullParser xpp, BoxWriter writer, int anno) throws Exception {
        String name = xpp.getAttribute("name");
        String v = MVXLoader.getValue(xpp);
        if (v == null) {
            logger.warning("skipped null value of annotation " + name);
        } else if (name.equals("http://ontobox.org/#maxcard") && v.equals("-1")) {
            logger.warning("skipped -1 max cardinality ");
        } else {
            writer.annotate(anno, xpp.getAttribute("name"), v);
        }
    }

    private static void loadAnnoAll(XMLPullParser xpp, Map<String, String> entity, String endTag) throws Exception {
        String t;
        while ((t = xpp.startAnyTag(endTag)) != null) {
            if (t.equals("annotation")) {
                MVXLoader.loadAnno(xpp, entity);
            }
            xpp.endTag(t);
        }
    }

    private static void loadAnnoAll(XMLPullParser xpp, BoxWriter writer, int entity, String endTag) throws Exception {
        String t;
        while ((t = xpp.startAnyTag(endTag)) != null) {
            if (t.equals("annotation")) {
                MVXLoader.loadAnno(xpp, writer, entity);
            }
            xpp.endTag(t);
        }
    }

    private static boolean skipOntology(XMLPullParser xpp, String uri) throws Exception {
        if (uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://ontobox.org/") || uri.equals("http://xml.ontobox.org/")) {
            logger.warning("Skipped " + uri + " ontology");
            xpp.endTag("ontology");
            return true;
        }
        if (N.isBadOntology(uri)) {
            logger.warning("Skipped " + uri + " ontology as bad");
            xpp.endTag("ontology");
            return true;
        }
        return false;
    }

    private static void startOntologyStep1(XMLPullParser xpp, BoxWorker worker, ProgressListener listener, OntologyProcessor ontologyProcessor) throws Exception {
        String tag;
        BoxWriter writer = worker.write();
        String uri = xpp.getAttribute("uri");
        String action = "1/3. \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + uri;
        listener.nextStep(action);
        if (MVXLoader.skipOntology(xpp, uri)) {
            return;
        }
        ontologyProcessor.preloadOntology(worker, uri);
        int ont = worker.entity(uri) == Entity.ONTOLOGY ? worker.id(uri).intValue() : writer.newOntology(uri);
        while ((tag = xpp.startAnyTag("ontology")) != null) {
            if (tag.equals("annotation")) {
                MVXLoader.loadAnno(xpp, writer, ont);
                xpp.endTag(tag);
                continue;
            }
            if (tag.equals("type")) {
                int type = writer.newType(uri + "#" + xpp.getAttribute("name"));
                MVXLoader.loadAnnoAll(xpp, writer, type, tag);
                continue;
            }
            if (tag.equals("ontclass")) {
                String fullName = uri + '#' + xpp.getAttribute("name");
                int cl = worker.entity(fullName) != Entity.ONTCLASS || !fullName.startsWith("http://ontobox.org/map#tcl-") && !fullName.startsWith("http://ontobox.org/map#ocl-") && !fullName.equals("http://ontobox.org/map#Map") ? writer.newClass(fullName) : worker.id(fullName).intValue();
                MVXLoader.loadAnnoAll(xpp, writer, cl, tag);
                continue;
            }
            xpp.endTag(tag);
        }
    }

    public static void loadBackupStep2(InputStream in, BoxWorker worker, ProgressListener listener) {
        XMLPullParser xpp;
        logger.info("step2");
        try {
            xpp = new XMLPullParser(in);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        try {
            String tag;
            xpp.startTag("ontobase", "ontobox");
            while ((tag = xpp.startAnyTag("ontobase", "ontobox")) != null) {
                if (tag.equals("ontology")) {
                    MVXLoader.startOntologyStep2(xpp, worker, listener);
                    continue;
                }
                xpp.endTag(tag);
            }
        }
        catch (Exception e) {
            throw new ParseException(e, xpp);
        }
    }

    private static void startOntologyStep2(XMLPullParser xpp, BoxWorker worker, ProgressListener listener) throws Exception {
        String tag;
        BoxWriter writer = worker.write();
        String uri = xpp.getAttribute("uri");
        String action = "2/3. \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + uri;
        listener.nextStep(action);
        if (MVXLoader.skipOntology(xpp, uri)) {
            return;
        }
        while ((tag = xpp.startAnyTag("ontology")) != null) {
            String max;
            String min;
            String range;
            String domain;
            Integer maxCard;
            Integer minCard;
            if (tag.equals("ontclass")) {
                String t;
                int cl = worker.id(uri + '#' + xpp.getAttribute("name"));
                while ((t = xpp.startAnyTag("ontclass")) != null) {
                    if (t.equals("superClass")) {
                        int superClass = worker.resolve(xpp.getAttribute("name"), Entity.ONTCLASS);
                        writer.addSubclass(superClass, cl);
                    }
                    xpp.endTag(t);
                }
                continue;
            }
            if (tag.equals("ontobject")) {
                String t;
                String fn = uri + '#' + xpp.getAttribute("name");
                ArrayList<String> objClasses = new ArrayList<String>();
                while ((t = xpp.startAnyTag("ontobject")) != null) {
                    if (t.equals("objectClass")) {
                        objClasses.add(xpp.getAttribute("name"));
                    } else if (t.equals("annotation")) {
                        logger.warning("Skipped " + xpp.getAttribute("name") + " annotation for the " + fn + " object.");
                    }
                    xpp.endTag(t);
                }
                boolean badObject = !objClasses.isEmpty();
                for (String clName : objClasses) {
                    if (N.isBadEntity(clName)) continue;
                    badObject = false;
                    break;
                }
                if (badObject) continue;
                int obj = writer.newObject(fn);
                for (String clName : objClasses) {
                    writer.addObjectClass(obj, worker.resolve(clName, Entity.ONTCLASS));
                }
                continue;
            }
            if (tag.equals("tproperty")) {
                int tprop;
                String fullName = uri + '#' + xpp.getAttribute("name");
                if (worker.entity(fullName) != Entity.TPROPERTY || !fullName.startsWith("http://ontobox.org/map#tprop-")) {
                    Integer domainClass = null;
                    Integer rangeType = null;
                    minCard = null;
                    maxCard = null;
                    domain = xpp.getAttribute("domainClass", null);
                    range = xpp.getAttribute("rangeType", null);
                    min = xpp.getAttribute("minCard", null);
                    max = xpp.getAttribute("maxCard", null);
                    if (domain != null) {
                        domainClass = worker.resolve(domain, Entity.ONTCLASS);
                    }
                    if (range != null) {
                        rangeType = worker.resolve(TypeMap.type(range), Entity.TYPE);
                    }
                    if (min != null) {
                        minCard = Integer.parseInt(min);
                    }
                    if (max != null) {
                        maxCard = Integer.parseInt(max);
                    }
                    tprop = writer.newTProperty(fullName);
                    if (domainClass != null) {
                        writer.setDomain(tprop, domainClass);
                    }
                    if (rangeType != null) {
                        writer.setRange(tprop, rangeType);
                    }
                    if (minCard != null) {
                        writer.annotate(tprop, "http://ontobox.org/#mincard", minCard.toString());
                    }
                    if (maxCard != null) {
                        writer.annotate(tprop, "http://ontobox.org/#maxcard", maxCard.toString());
                    }
                } else {
                    tprop = worker.id(fullName);
                }
                MVXLoader.loadAnnoAll(xpp, writer, tprop, tag);
                continue;
            }
            if (tag.equals("oproperty")) {
                int oprop;
                String fullName = uri + '#' + xpp.getAttribute("name");
                if (worker.entity(fullName) != Entity.OPROPERTY || !fullName.startsWith("http://ontobox.org/map#oprop-")) {
                    Integer domainClass = null;
                    Integer rangeClass = null;
                    minCard = null;
                    maxCard = null;
                    domain = xpp.getAttribute("domainClass", null);
                    range = xpp.getAttribute("rangeClass", null);
                    min = xpp.getAttribute("minCard", null);
                    max = xpp.getAttribute("maxCard", null);
                    if (domain != null) {
                        domainClass = worker.resolve(domain, Entity.ONTCLASS);
                    }
                    if (range != null) {
                        rangeClass = worker.resolve(range, Entity.ONTCLASS);
                    }
                    if (min != null) {
                        minCard = Integer.parseInt(min);
                    }
                    if (max != null) {
                        maxCard = Integer.parseInt(max);
                    }
                    oprop = writer.newOProperty(fullName);
                    if (domainClass != null) {
                        writer.setDomain(oprop, domainClass);
                    }
                    if (rangeClass != null) {
                        writer.setRange(oprop, rangeClass);
                    }
                    if (minCard != null) {
                        writer.annotate(oprop, "http://ontobox.org/#mincard", minCard.toString());
                    }
                    if (maxCard != null) {
                        writer.annotate(oprop, "http://ontobox.org/#maxcard", maxCard.toString());
                    }
                } else {
                    oprop = worker.id(fullName);
                }
                MVXLoader.loadAnnoAll(xpp, writer, oprop, tag);
                continue;
            }
            xpp.endTag(tag);
        }
    }

    public static void loadBackupStep3(InputStream in, BoxWorker worker, ProgressListener listener) {
        XMLPullParser xpp;
        logger.info("step3");
        StringCompressor strcomp = new StringCompressor();
        try {
            xpp = new XMLPullParser(in);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
        try {
            String tag;
            xpp.startTag("ontobase", "ontobox");
            while ((tag = xpp.startAnyTag("ontobase", "ontobox")) != null) {
                if (tag.equals("ontology")) {
                    MVXLoader.startOntologyStep3(xpp, worker, strcomp, listener);
                    continue;
                }
                xpp.endTag(tag);
            }
        }
        catch (Exception e) {
            throw new ParseException(e, xpp);
        }
    }

    private static void startOntologyStep3(XMLPullParser xpp, BoxWorker worker, StringCompressor strcomp, ProgressListener listener) throws Exception {
        String tag;
        BoxWriter writer = worker.write();
        String uri = xpp.getAttribute("uri");
        String action = "3/3. \u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + uri;
        listener.nextStep(action);
        if (MVXLoader.skipOntology(xpp, uri)) {
            return;
        }
        while ((tag = xpp.startAnyTag("ontology")) != null) {
            if (tag.equals("ontobject")) {
                String t;
                String fn = uri + '#' + xpp.getAttribute("name");
                Integer obj = worker.id(fn);
                while ((t = xpp.startAnyTag("ontobject")) != null) {
                    if (obj != null) {
                        String v;
                        if (t.equals("ovalue")) {
                            String opropFN = xpp.getAttribute("oproperty");
                            int oprop = worker.resolve(opropFN, Entity.OPROPERTY);
                            v = xpp.getAttribute("value", null);
                            if (v != null) {
                                writer.addObject(obj, oprop, worker.resolve(v, Entity.ONTOBJECT));
                            } else {
                                logger.warning("skipped null ovalue (" + opropFN + ')');
                            }
                        } else if (t.equals("tvalue")) {
                            String tpropFN = xpp.getAttribute("tproperty");
                            int tprop = worker.resolve(tpropFN, Entity.TPROPERTY);
                            v = MVXLoader.getValue(xpp);
                            if (v != null) {
                                writer.addString((int)obj, tprop, strcomp.string(v));
                            } else {
                                logger.warning("skipped null tvalue (" + tpropFN + ')');
                            }
                        }
                    } else {
                        logger.warning("Skipped \"bad\" object: " + fn);
                    }
                    xpp.endTag(t);
                }
                continue;
            }
            xpp.endTag(tag);
        }
    }

    public static class ParseException
    extends RuntimeException {
        public ParseException(Throwable tr, XMLPullParser xpp) {
            super(tr.toString() + "\n(" + xpp.getPosition() + ')', tr);
        }

        public ParseException(Throwable tr) {
            super(tr);
        }
    }
}

