/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.DeleteOPropertyEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateOProperty;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class DeleteOProperty
implements WriteAction,
DeleteOPropertyEvent {
    private final String name;

    public DeleteOProperty(String[] data) {
        this(data[0]);
    }

    public DeleteOProperty(String name) {
        this.name = name;
    }

    @Override
    public final String getPropertyName() {
        return this.name;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentOProperty(this.name);
        BMapIntIntLazy ov = (BMapIntIntLazy)storage.ovalues.get(storage.id(this.name).intValue());
        if (ov != null && ov.keys().length != 0) {
            throw new DeleteException("Oproperty", this.name, "It has ovalues");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        storage.opropDomain.removeDirectKey(id);
        storage.opropRange.removeDirectKey(id);
        storage.oProperties.removeDirectKey(id);
        storage.ovalues.removeKey(id);
        storage.deleteNameAndAnno(this.name);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new CreateOProperty(this.name);
    }
}

