/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntCollection;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import org.ontobox.box.event.DeleteObjectEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateObject;
import org.ontobox.fast.action.DeleteClass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;

public class DeleteObject
implements WriteAction,
DeleteObjectEvent {
    private final String name;

    public DeleteObject(String[] data) {
        this(data[0]);
    }

    public DeleteObject(String name) {
        this.name = name;
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final void preverify(final Storage storage) {
        storage.verifyExistentObject(this.name);
        final int id = storage.id(this.name);
        if (!storage.objectClasses.getDirect(id).isEmpty()) {
            throw new DeleteException("Object", this.name, "It has classes");
        }
        storage.ovalues.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

            public boolean process(int i, BMapIntIntLazy ov) {
                if (!ov.getReverse(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It is " + storage.name(i) + " ovalue of " + DeleteClass.getEntities(storage, (IntCollection)ov.getReverse(id), 10));
                }
                if (!ov.getDirect(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It has " + storage.name(i) + " ovalue");
                }
                return true;
            }
        });
        storage.tstrings.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntStringLazy>(){

            public boolean process(int i, BMapIntStringLazy tv) {
                if (!tv.getDirect(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It has string value of " + storage.name(i));
                }
                return true;
            }
        });
        storage.tbooleans.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntBooleanLazy>(){

            public boolean process(int i, BMapIntBooleanLazy tv) {
                if (!tv.getDirect(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It has boolean value of " + storage.name(i));
                }
                return true;
            }
        });
        storage.tintegers.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

            public boolean process(int i, BMapIntIntLazy tv) {
                if (!tv.getDirect(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It has integer value of " + storage.name(i));
                }
                return true;
            }
        });
        storage.tlongs.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntLongLazy>(){

            public boolean process(int i, BMapIntLongLazy tv) {
                if (!tv.getDirect(id).isEmpty()) {
                    throw new DeleteException("Object", DeleteObject.this.name, "It has long or date-time value of " + storage.name(i));
                }
                return true;
            }
        });
    }

    @Override
    public final void doAction(Storage storage) {
        storage.objects.removeDirectKey(storage.id(this.name));
        storage.deleteNameAndAnno(this.name);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new CreateObject(this.name);
    }
}

