/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.SetTPropertyRangeEvent;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;

public class SetTPropertyRange
implements WriteAction,
SetTPropertyRangeEvent {
    private final String name;
    private final String range;
    private String oldRange;

    public SetTPropertyRange(String[] data) {
        this(data[0], data[1]);
    }

    public SetTPropertyRange(String name, String range) {
        this.name = name;
        this.range = range;
    }

    @Override
    public final void preverify(Storage storage) {
        BMapInt ts;
        storage.verifyExistentTProperty(this.name);
        if (this.range != null) {
            storage.verifyExistentType(this.range);
        }
        if ((ts = storage.getValueMap(storage.id(this.name))) != null && ts.keys().length != 0) {
            throw new IllegalStateException("There are values, so range cannot be changed for " + this.name);
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        Integer oldRangeId = storage.tpropRange.getDirect(id);
        if (oldRangeId != null) {
            this.oldRange = storage.name(oldRangeId);
        }
        if (this.range == null) {
            storage.tpropRange.put(id, null);
        } else {
            storage.tpropRange.put(id, storage.id(this.range));
        }
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.range};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new SetTPropertyRange(this.name, this.oldRange);
    }

    public final String getName() {
        return this.name;
    }

    public final String getRange() {
        return this.range;
    }

    public final String getOldRange() {
        return this.oldRange;
    }
}

