/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.box;

import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import java.util.ArrayList;
import org.ontobox.box.base.BaseBoxWriter;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.AddOValue;
import org.ontobox.fast.action.AddObjectClass;
import org.ontobox.fast.action.AddSubclass;
import org.ontobox.fast.action.AddTValue;
import org.ontobox.fast.action.CreateClass;
import org.ontobox.fast.action.CreateOProperty;
import org.ontobox.fast.action.CreateObject;
import org.ontobox.fast.action.CreateOntology;
import org.ontobox.fast.action.CreateTProperty;
import org.ontobox.fast.action.CreateType;
import org.ontobox.fast.action.DeleteClass;
import org.ontobox.fast.action.DeleteOProperty;
import org.ontobox.fast.action.DeleteObject;
import org.ontobox.fast.action.DeleteOntology;
import org.ontobox.fast.action.DeleteTProperty;
import org.ontobox.fast.action.DeleteType;
import org.ontobox.fast.action.ReadAction;
import org.ontobox.fast.action.RemoveOValue;
import org.ontobox.fast.action.RemoveObjectClass;
import org.ontobox.fast.action.RemoveSubclass;
import org.ontobox.fast.action.RemoveTValue;
import org.ontobox.fast.action.SetAnnotation;
import org.ontobox.fast.action.SetName;
import org.ontobox.fast.action.SetOPropertyDomain;
import org.ontobox.fast.action.SetOPropertyRange;
import org.ontobox.fast.action.SetTPropertyDomain;
import org.ontobox.fast.action.SetTPropertyRange;
import org.ontobox.fast.action.SetURI;
import org.ontobox.fast.box.FastBoxWorker;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class FastBoxWriter
extends BaseBoxWriter {
    private FastBoxWorker worker;

    public FastBoxWriter(FastBoxWorker worker) {
        super(worker);
        this.worker = worker;
    }

    @Override
    public int createOntology(String uri) {
        this.worker.execute(new CreateOntology(uri));
        return this.worker.id(uri);
    }

    @Override
    public int createClass(String name) {
        this.worker.execute(new CreateClass(name));
        return this.worker.id(name);
    }

    @Override
    public int createObject(final String name) {
        this.worker.execute(new CreateObject(name));
        return this.worker.read(new ReadAction<Integer>(){

            @Override
            public Integer read(Storage storage) {
                return storage.id(name);
            }
        });
    }

    @Override
    public int createOProperty(String fn) {
        this.worker.execute(new CreateOProperty(fn));
        return this.worker.id(fn);
    }

    @Override
    public int createTProperty(String fn) {
        this.worker.execute(new CreateTProperty(fn));
        return this.worker.id(fn);
    }

    @Override
    public int createType(String fn) {
        this.worker.execute(new CreateType(fn));
        return this.worker.id(fn);
    }

    @Override
    protected void domainForTProperty(int prop, Integer domain) {
        String d = domain != null ? this.worker.name(domain) : null;
        this.worker.execute(new SetTPropertyDomain(this.worker.name(prop), d));
    }

    @Override
    protected void domainForOProperty(int prop, Integer domain) {
        String d = domain != null ? this.worker.name(domain) : null;
        this.worker.execute(new SetOPropertyDomain(this.worker.name(prop), d));
    }

    @Override
    protected void rangeForTProperty(int prop, Integer range) {
        String r = range != null ? this.worker.name(range) : null;
        this.worker.execute(new SetTPropertyRange(this.worker.name(prop), r));
    }

    @Override
    protected void rangeForOProperty(int prop, Integer range) {
        String r = range != null ? this.worker.name(range) : null;
        this.worker.execute(new SetOPropertyRange(this.worker.name(prop), r));
    }

    @Override
    public void addSubclass(int sup, int sub) {
        this.worker.execute(new AddSubclass(this.worker.name(sup), this.worker.name(sub)));
    }

    @Override
    public void removeSubclass(int sup, int sub) {
        this.worker.execute(new RemoveSubclass(this.worker.name(sup), this.worker.name(sub)));
    }

    @Override
    public void addObjectClass(int object, int cl) {
        this.worker.execute(new AddObjectClass(this.worker.name(object), this.worker.name(cl)));
    }

    @Override
    public void removeObjectClass(int object, int cl) {
        this.worker.execute(new RemoveObjectClass(this.worker.name(object), this.worker.name(cl)));
    }

    @Override
    public void addObject(int object, int oprop, int index, int value) {
        this.worker.execute(new AddOValue(this.worker.name(object), this.worker.name(oprop), this.worker.name(value), index));
    }

    @Override
    public void addString(int object, int oprop, int index, String value) {
        this.worker.execute(new AddTValue(this.worker.name(object), this.worker.name(oprop), value, index));
    }

    @Override
    protected void removeValueForTProperty(int object, int prop, int index) {
        this.worker.execute(new RemoveTValue(this.worker.name(object), this.worker.name(prop), index));
    }

    @Override
    protected void removeValueForOProperty(int object, int prop, int index) {
        this.worker.execute(new RemoveOValue(this.worker.name(object), this.worker.name(prop), index));
    }

    @Override
    protected void deleteForType(int id) {
        this.worker.execute(new DeleteType(this.worker.name(id)));
    }

    @Override
    protected void deleteForClass(int id) {
        String n = this.worker.name(id);
        for (int cl : this.worker.classesDirect(id)) {
            this.worker.execute(new RemoveSubclass(this.worker.name(cl), n));
        }
        this.worker.execute(new DeleteClass(n));
    }

    @Override
    protected void deleteForObject(final int id) {
        final String n = this.worker.name(id);
        this.worker.read(new ReadAction<Object>(){

            @Override
            public Object read(final Storage storage) {
                storage.ovalues.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

                    public boolean process(int key, BMapIntIntLazy value) {
                        IntSet owners = value.getReverse(id);
                        if (!owners.isEmpty()) {
                            throw new DeleteException("Object", n, "the object is an o-property value\nO-Property :" + storage.name(key));
                        }
                        return true;
                    }
                });
                return null;
            }
        });
        ArrayList<Integer> cascadeDelete = new ArrayList<Integer>();
        for (int oprop : this.worker.oprops(id)) {
            if (!"cascade-delete".equals(this.worker.anno(oprop, "http://meta2project.org/model#cascade"))) continue;
            for (int value : this.worker.objects(id, oprop)) {
                cascadeDelete.add(value);
            }
        }
        this.removeValues(id);
        for (final Integer value : cascadeDelete) {
            Boolean free = this.worker.read(new ReadAction<Boolean>(){

                @Override
                public final Boolean read(Storage storage) {
                    return storage.ovalues.forEachValue((ObjectProcessor)new ObjectProcessor<BMapIntIntLazy>(){

                        public boolean process(BMapIntIntLazy ov) {
                            return ov.getReverse(value).isEmpty();
                        }
                    });
                }
            });
            if (!free.booleanValue()) continue;
            this.delete(value);
        }
        for (int cl : this.worker.classesDirect(id)) {
            this.worker.execute(new RemoveObjectClass(n, this.worker.name(cl)));
        }
        this.worker.execute(new DeleteObject(n));
    }

    @Override
    protected void deleteForOntology(int id) {
        this.worker.execute(new DeleteOntology(this.worker.name(id)));
    }

    @Override
    protected void deleteForOProperty(int id) {
        this.worker.execute(new DeleteOProperty(this.worker.name(id)));
    }

    @Override
    protected void deleteForTProperty(int id) {
        this.worker.execute(new DeleteTProperty(this.worker.name(id)));
    }

    @Override
    protected void renameOntology(int id, String newFn) {
        this.worker.execute(new SetURI(this.worker.name(id), newFn));
    }

    @Override
    protected void renameNamedEntity(int id, String newFn) {
        this.worker.execute(new SetName(this.worker.name(id), newFn));
    }

    @Override
    protected void annotateForEntity(int id, String name, String value) {
        this.worker.execute(new SetAnnotation(this.worker.name(id), name, value));
    }
}

