/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.fast.Engine;
import org.ontobox.fast.TransactionRW;
import org.ontobox.fast.action.ReadAction;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.queue.ActionsQueue;
import org.ontobox.fast.queue.QueueProcessor;
import org.ontobox.fast.storage.BinaryDumper;
import org.ontobox.fast.storage.BinaryLogLoader;
import org.ontobox.fast.storage.BinaryLogSaver;
import org.ontobox.fast.storage.Initer;
import org.ontobox.fast.storage.JournalCleaner;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.storage.Verifier;

public class DiskWorker {
    private static final Logger logger = Logger.getLogger(DiskWorker.class.getName());
    private static final String LOCK = "lock";
    private static final String DUMP_BINARY = "dump.data";
    private static final String DUMP_BINARY_NEW = "dump.data.new";
    private static final String LOG = "trace.data";
    private final Engine engine;
    private final File dir;
    private RandomAccessFile lockFile;
    private FileLock lockLock;
    ActionsQueue journal;
    private JournalCleaner cleaner;

    public DiskWorker(File dir, Storage storage, Engine engine) throws IOException {
        this.dir = dir;
        this.engine = engine;
        dir.mkdirs();
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not found, or not directory");
        }
        this.lockFile = new RandomAccessFile(new File(dir, LOCK), "rw");
        this.lockLock = this.lockFile.getChannel().tryLock();
        if (this.lockLock == null) {
            throw new IllegalStateException("The disk ontobase \"" + dir + "\" is locked by another process. Please try later.");
        }
        this.restoreAll(storage);
    }

    public void putTransactionActions(Collection<WriteAction> actions) {
        this.journal.putActions(actions);
        this.journal.putCheckActions();
    }

    void restoreAll(Storage storage) {
        DiskWorker.restoreDump(storage, new File(this.dir, DUMP_BINARY));
        int restored = DiskWorker.restoreLog(storage, new File(this.dir, LOG));
        if (restored > 0) {
            this.dumpCurrent(storage);
        }
        this.startJournal();
        this.putTransactionActions(Initer.init(storage));
        try {
            Verifier.verify(storage);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Verify failed: " + e.getMessage(), e);
        }
        this.cleaner = new JournalCleaner(this);
        this.cleaner.start();
    }

    private void startJournal() {
        this.journal = new ActionsQueue(new QueueProcessor(){
            final BinaryLogSaver logSaver;
            {
                this.logSaver = new BinaryLogSaver(new File(DiskWorker.this.dir, DiskWorker.LOG));
            }

            @Override
            public void process(WriteAction action) throws Exception {
                this.logSaver.saveAction(action);
            }

            @Override
            public void flush() throws Exception {
                this.logSaver.flush();
            }

            @Override
            public void close() {
                this.logSaver.close();
            }
        }, "log saver");
    }

    private static void restoreDump(Storage storage, File file) {
        try {
            new BinaryDumper(storage).loadBinary(file);
        }
        catch (FileNotFoundException e) {
        }
        catch (Throwable e) {
            throw new RuntimeException("Broken dump-file (" + file + "), cannot start the fast engine (" + e.toString() + ")", e);
        }
    }

    private static int restoreLog(Storage storage, File file) {
        try {
            int ret = new BinaryLogLoader(file).loadActions(storage);
            return ret > 0 ? ret : 1;
        }
        catch (FileNotFoundException e) {
            return 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Broken journal-file (" + file + "), cannot start the fast engine", e);
        }
    }

    void cleanupFiles(File dumpBinaryNew) {
        File dumpBinary = new File(this.dir, DUMP_BINARY);
        if (dumpBinary.exists() && !dumpBinary.delete()) {
            return;
        }
        if (!dumpBinaryNew.renameTo(dumpBinary)) {
            return;
        }
        File file = new File(this.dir, LOG);
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
        }
    }

    void dumpCurrent(Storage storage) {
        File dumpBinaryNew = new File(this.dir, DUMP_BINARY_NEW);
        try {
            new BinaryDumper(storage).dumpBinary(dumpBinaryNew);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.cleanupFiles(dumpBinaryNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws Throwable {
        TransactionRW transaction = this.engine.openTransactionRW();
        try {
            transaction.read(new ReadAction<Void>(){

                @Override
                public Void read(Storage storage) {
                    DiskWorker.this.journal.close();
                    DiskWorker.this.dumpCurrent(storage);
                    storage.compressStrings();
                    DiskWorker.this.startJournal();
                    return null;
                }
            });
        }
        finally {
            transaction.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(Storage storage) {
        boolean ret = true;
        try {
            this.cleaner.close();
            this.journal.close();
            this.dumpCurrent(storage);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "closing error", e);
            ret = false;
        }
        finally {
            try {
                this.lockLock.release();
                this.lockFile.close();
                File file = new File(this.dir, LOCK);
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "unlock error", e);
            }
        }
        return ret;
    }
}

