/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.map;

import com.teacode.collection.primitive.BooleanList;
import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntObjectMap;

public class MapIntBooleanList {
    private final IntObjectMap<BooleanList> map;
    private static final BooleanList EMPTY_LIST = CCreator.newBooleanList((int)1);

    public MapIntBooleanList() {
        this.map = CCreator.newIntObjectMap((int)16);
    }

    public MapIntBooleanList(int size) {
        this.map = CCreator.newIntObjectMap((int)size);
    }

    public final int add(int key, boolean value) {
        BooleanList list = (BooleanList)this.map.get(key);
        if (list == null) {
            list = CCreator.newBooleanList((int)16);
            this.map.put(key, (Object)list);
        }
        list.add(value);
        return list.size() - 1;
    }

    public final int add(int key, int index, boolean value) {
        if (index == -1) {
            return this.add(key, value);
        }
        BooleanList list = (BooleanList)this.map.get(key);
        if (list == null) {
            list = CCreator.newBooleanList((int)16);
            this.map.put(key, (Object)list);
        }
        list.insert(index, value);
        return index;
    }

    public final BooleanList get(int key) {
        BooleanList list = (BooleanList)this.map.get(key);
        if (list == null) {
            return EMPTY_LIST;
        }
        return list;
    }

    public final int[] keys() {
        return this.map.keys();
    }

    public final void removeKey(int key) {
        this.map.removeKey(key);
    }

    public final void removeValues(int key, boolean value) {
        BooleanList list = this.get(key);
        int index = 0;
        while ((index = list.indexOf(index, value)) != -1) {
            list.removeIndex(index);
        }
        if (list.isEmpty()) {
            this.map.removeKey(key);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

