/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.mapmany;

import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import java.util.logging.Logger;
import org.ontobox.fast.util.map.MapIntIntList;
import org.ontobox.fast.util.map.MapIntIntSet;
import org.ontobox.fast.util.mapmany.BMapInt;

public class BMapIntIntLazy
implements BMapInt {
    private static final Logger logger = Logger.getLogger(BMapIntIntLazy.class.getName());
    private final MapIntIntList direct;
    private MapIntIntSet reverse = null;

    public BMapIntIntLazy() {
        this.direct = new MapIntIntList();
    }

    public BMapIntIntLazy(int size) {
        this.direct = new MapIntIntList(size);
    }

    public final void add(int key, int value) {
        this.direct.add(key, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final void add(int key, int index, int value) {
        this.direct.add(key, index, value);
        if (this.reverse != null) {
            this.reverse.put(value, key);
        }
    }

    public final boolean isEmpty() {
        return this.direct.isEmpty();
    }

    public final IntList getDirect(int key) {
        return this.direct.get(key);
    }

    @Override
    public String getDirectAsString(int key, int index) {
        return String.valueOf(this.getDirect(key).get(index));
    }

    @Override
    public int getDirectSize(int key) {
        return this.getDirect(key).size();
    }

    private synchronized void initReverse() {
        if (this.reverse == null) {
            int[] keys = this.direct.keys();
            this.reverse = new MapIntIntSet(keys.length);
            for (final int key : keys) {
                this.direct.get(key).forEach(new IntProcessor(){

                    public boolean process(int i) {
                        BMapIntIntLazy.this.reverse.put(i, key);
                        return true;
                    }
                });
            }
        }
    }

    public final IntSet getReverse(int value) {
        this.initReverse();
        return this.reverse.get(value);
    }

    @Override
    public final int[] keys() {
        return this.direct.keys();
    }

    public final int[] reverseKeySet() {
        this.initReverse();
        return this.reverse.keys();
    }

    final void removeDirectKey(final int key) {
        if (this.reverse != null) {
            this.getDirect(key).forEach(new IntProcessor(){

                public boolean process(int value) {
                    BMapIntIntLazy.this.reverse.removeValues(value, key);
                    return true;
                }
            });
        }
        this.direct.removeKey(key);
    }

    @Override
    public final void removeDirect(int key, int index) {
        IntList vList = this.direct.get(key);
        int value = vList.get(index);
        if (this.reverse != null) {
            this.reverse.removeValues(value, key);
        }
        vList.removeIndex(index);
        if (vList.isEmpty()) {
            this.removeDirectKey(key);
        }
    }
}

