/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.collection;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.M;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;

public class PathComparator
implements Comparator {
    private final Sequence pathList;
    private final Interp interp;
    private final Map<ObjectToken, Comparable> cache = new HashMap<ObjectToken, Comparable>();
    private static EmptyCollection emptyCollection = new EmptyCollection();

    public PathComparator(Interp m2pi, Sequence pl) {
        this.pathList = pl;
        this.interp = m2pi;
    }

    private Comparable extract(Object t, Token path) {
        Object o = this.interp.calcPredicate(t, path, M.P_COMPUTE, t, null, null);
        if (Interp.isFalse(o)) {
            return emptyCollection;
        }
        if (o instanceof OntCollection) {
            o = ((OntCollection)o).get(0);
        }
        if (o instanceof Comparable) {
            return (Comparable)o;
        }
        throw new ClassCastException("Sorter items must be resolved into comparable data values (e.g. strings). Actual value class: " + PathComparator.cl(o));
    }

    private Comparable extractCache(Object t, Token path) {
        ObjectToken ot = new ObjectToken(t, path);
        Comparable ret = this.cache.get(ot);
        if (ret != null) {
            return ret;
        }
        ret = this.extract(t, path);
        this.cache.put(ot, ret);
        return ret;
    }

    public int compare(Object t1, Object t2) {
        t1 = ObjectContainer.getObject(t1);
        t2 = ObjectContainer.getObject(t2);
        for (int i = 0; i < this.pathList.size(); ++i) {
            Token path = this.pathList.getFast(i);
            Comparable comp1 = this.extractCache(t1, path);
            Comparable comp2 = this.extractCache(t2, path);
            if (comp1 instanceof EmptyCollection) {
                if (comp2 instanceof EmptyCollection) continue;
                return 1;
            }
            if (comp2 instanceof EmptyCollection) {
                return -1;
            }
            int ret = comp1.compareTo(comp2);
            if (ret == 0) continue;
            return ret;
        }
        if (!t1.equals(t2)) {
            return 1;
        }
        return 0;
    }

    private static String cl(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName();
    }

    private static class EmptyCollection
    implements Comparable {
        private EmptyCollection() {
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException("Comparing empty collections is unsupported");
        }
    }

    private static class ObjectToken {
        private final Object object;
        private final Token token;

        private ObjectToken(Object object, Token token) {
            this.object = object;
            this.token = token;
        }

        public int hashCode() {
            return this.object.hashCode() + this.token.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectToken)) {
                return false;
            }
            ObjectToken ot = (ObjectToken)obj;
            return this.object.equals(ot.object) && this.token.equals(ot.token);
        }
    }
}

