/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import com.teacode.web.HTMLHelper;
import java.io.StringWriter;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.XMLHelper;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.XMLCompiler;

public class XMLFuncs {
    public static void init(FunctionTable funs) {
        funs.pushFunction(new XE1());
        funs.pushFunction(new XE0());
        funs.pushFunction(new XEE1());
        funs.pushFunction(new XEE0());
        funs.pushFunction(new XA0());
        funs.pushFunction(new XA1());
        funs.pushFunction(new XT0());
        funs.pushFunction(new XTT0());
        funs.pushFunction(new XATTR2());
        funs.pushFunction(new XDOC0());
        funs.pushFunction(new XELEM1());
        funs.pushFunction(new XTEXT1());
        funs.pushFunction(new XADD1());
        funs.pushFunction(new XENTITY1());
        funs.pushFunction(new XENTITIES0());
        funs.pushFunction(new XESC1());
        funs.pushFunction(new XSetHeap1());
        funs.pushFunction(new XGetHeap0());
        funs.pushFunction(new FunWriteXML0());
        funs.pushFunction(new FunWriteHTML0());
    }

    private static void getAllText(LocalContext lc, OntCollection result, int curId) {
        BoxWorker w = lc.getWorker();
        for (int id : w.objects(curId, lc.getXmlContentProp())) {
            if (XMLFuncs.isText(lc, id)) {
                result.addAllTyped(w.strings(id, lc.getXmlTextProp()));
            }
            if (!XMLHelper.isElement(w, id)) continue;
            XMLFuncs.getAllText(lc, result, id);
        }
    }

    private static boolean is(LocalContext lc, int objid, int clsid) {
        return RHelper.isInstanceOf(lc.getWorker(), objid, clsid);
    }

    private static boolean isElem(LocalContext lc, int objid) {
        return RHelper.isInstanceOf(lc.getWorker(), objid, lc.getXmlEl());
    }

    private static boolean isText(LocalContext lc, int objid) {
        return RHelper.isInstanceOf(lc.getWorker(), objid, lc.getXmlText());
    }

    private static boolean isAttr(LocalContext lc, int objid) {
        return RHelper.isInstanceOf(lc.getWorker(), objid, lc.getXmlAttr());
    }

    private static String getName(LocalContext lc, int objid) {
        return lc.getWorker().strings(objid, lc.getXmlNameProp())[0];
    }

    private static String getValue(LocalContext lc, int objid) {
        return lc.getWorker().strings(objid, lc.getXmlValProp())[0];
    }

    private static String getText(LocalContext lc, int objid) {
        return lc.getWorker().strings(objid, lc.getXmlTextProp())[0];
    }

    private static int[] getAttrs(LocalContext lc, int objid) {
        return lc.getWorker().objects(objid, lc.getXmlAttrProp());
    }

    private static int newEntity(LocalContext lc, int cls, Object onto) {
        BoxWriter wr = lc.getWorker().write();
        int ontid = Helper.getOntologyByAll(lc, onto).id();
        int objid = wr.newObject(wr.newName(ontid));
        wr.addObjectClass(objid, cls);
        return objid;
    }

    private static int newLWEntity(LocalContext lc, int cls) {
        BoxWriter wr = lc.getWorker().write();
        int objid = wr.newLWObject();
        wr.addObjectClass(objid, cls);
        return objid;
    }

    private static boolean isXMLNode(LocalContext lc, int oid) {
        BoxWorker worker = lc.getWorker();
        if (worker.entity(oid) != Entity.ONTOBJECT) {
            return false;
        }
        if (RHelper.isInstanceOf(worker, oid, lc.getXmlEl())) {
            return true;
        }
        if (RHelper.isInstanceOf(worker, oid, lc.getXmlAttr())) {
            return true;
        }
        if (RHelper.isInstanceOf(worker, oid, lc.getXmlDoc())) {
            return true;
        }
        return RHelper.isInstanceOf(worker, oid, lc.getXmlText());
    }

    private static void getAll(LocalContext lc, OntCollection result, String name, int curId) {
        BoxWorker w = lc.getWorker();
        String nm = w.strings(curId, lc.getXmlNameProp())[0];
        if (name == null || nm.equals(name)) {
            result.addAllTyped(ObjectId.newId(w, curId));
        }
        for (int id : w.objects(curId, lc.getXmlContentProp())) {
            if (!XMLHelper.isElement(w, id)) continue;
            XMLFuncs.getAll(lc, result, name, id);
        }
    }

    public static int newDoc(LocalContext lc, int root, Object onto) {
        int doc = XMLFuncs.newEntity(lc, lc.getXmlDoc(), onto);
        lc.getWorker().write().addObject(doc, lc.getXmlRootProp(), root);
        lc.getWorker().write().addObject(doc, lc.getXmlContentProp(), root);
        return doc;
    }

    static class FunWriteHTML0
    extends LibrettoFunction {
        FunWriteHTML0() {
            super("writeHTML", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            Object root = this.getCurrentValue();
            if (!(root instanceof ObjectId)) {
                throw new RuntimeException("The context value must be an XML object");
            }
            int id = ((ObjectId)root).id();
            StringWriter sw = new StringWriter();
            XMLHelper.exportHTML(lc.getWorker(), sw, id);
            return sw.toString();
        }
    }

    static class FunWriteXML0
    extends LibrettoFunction {
        FunWriteXML0() {
            super("writeXML", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            Object root = this.getCurrentValue();
            if (!(root instanceof ObjectId)) {
                throw new RuntimeException("The context value must be an XML object");
            }
            int id = ((ObjectId)root).id();
            StringWriter sw = new StringWriter();
            XMLHelper.exportXML(lc.getWorker(), sw, id);
            return sw.toString();
        }
    }

    static class XGetHeap0
    extends LibrettoFunction {
        XGetHeap0() {
            super("getHeap", 0, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            Integer heap = lc.getLE().getXMLHeap(lc);
            return OntologyId.newId(heap);
        }
    }

    static class XSetHeap1
    extends LibrettoFunction {
        XSetHeap1() {
            super("setHeap", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String xheap = this.getStringArg(1);
            lc.getLE();
            Integer oid = LibrettoEnv.setXMLHeap(lc, xheap);
            return OntologyId.newId(oid);
        }
    }

    static class XESC1
    extends LibrettoFunction {
        XESC1() {
            super("esc", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String text = this.getStringArg(1);
            return HTMLHelper.escape((String)text);
        }
    }

    static class XENTITIES0
    extends LibrettoFunction {
        XENTITIES0() {
            super("entities", 0, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            return OntCC.newCol(XMLCompiler.html5entities());
        }
    }

    static class XENTITY1
    extends LibrettoFunction {
        XENTITY1() {
            super("entity", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String entity = this.getStringArg(1);
            return XMLCompiler.getCharEntity(entity);
        }
    }

    static class XTEXT1
    extends LibrettoFunction {
        XTEXT1() {
            super("text", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String text = Helper.col2String(this.getArg(1), "");
            BoxWorker w = lc.getWorker();
            int objid = XMLFuncs.newLWEntity(lc, lc.getXmlText());
            w.write().addString(objid, lc.getXmlTextProp(), text);
            return ObjectId.newId(w, objid);
        }
    }

    static class XATTR2
    extends LibrettoFunction {
        XATTR2() {
            super("attr", 2, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String name = this.getStringArg(1);
            String value = Helper.col2String(this.getArg(2), " ");
            BoxWorker w = lc.getWorker();
            int objid = XMLFuncs.newLWEntity(lc, lc.getXmlAttr());
            w.write().addString(objid, lc.getXmlNameProp(), name);
            w.write().addString(objid, lc.getXmlValProp(), value);
            return ObjectId.newId(w, objid);
        }
    }

    static class XELEM1
    extends LibrettoFunction {
        XELEM1() {
            super("elem", 1, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String name = this.getStringM(1);
            BoxWorker w = lc.getWorker();
            int objid = XMLFuncs.newLWEntity(lc, lc.getXmlEl());
            w.write().addString(objid, lc.getXmlNameProp(), name);
            return ObjectId.newId(w, objid);
        }
    }

    static class XDOC0
    extends LibrettoFunction {
        XDOC0() {
            super("doc", 0, T.STATIC, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            Integer onto = lc.getLE().getXMLHeap(lc);
            BoxWorker w = lc.getWorker();
            int objid = XMLFuncs.newEntity(lc, lc.getXmlDoc(), onto);
            return ObjectId.newId(w, objid);
        }
    }

    static class XADD1
    extends LibrettoFunction {
        XADD1() {
            super("add", 1, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            Object o = this.getCurrentValue();
            if (!(o instanceof ObjectId)) {
                throw new RuntimeException("The context value of add/1 must be either an XML element node or XML document node");
            }
            int e = ((ObjectId)o).id();
            if (!RHelper.isInstanceOf(lc.getWorker(), e, lc.getXmlEl()) && !RHelper.isInstanceOf(lc.getWorker(), e, lc.getXmlDoc())) {
                throw new RuntimeException("The context value of add/1 must be either an XML element node or XML document node");
            }
            BoxWorker w = lc.getWorker();
            Object a = this.getArg(1);
            OntCollection addedcol = a instanceof OntCollection ? (OntCollection)a : OntCC.singleton(a);
            for (Object added : addedcol) {
                Integer aid;
                int onto = w.ontology(e);
                if (!(added instanceof ObjectId)) {
                    aid = XMLFuncs.newEntity(lc, lc.getXmlText(), onto);
                    w.write().addString((int)aid, lc.getXmlTextProp(), added.toString());
                } else {
                    aid = ((ObjectId)added).id();
                    if (RHelper.isInstanceOf(w, aid, lc.getXmlDoc())) {
                        int[] aidar = w.objects(aid, lc.getXmlContentProp());
                        if (aidar.length == 0) {
                            throw new RuntimeException("A document node without contents");
                        }
                        aid = aidar[0];
                    }
                }
                if (XMLFuncs.isElem(lc, aid)) {
                    w.write().addObject(e, lc.getXmlContentProp(), aid);
                    continue;
                }
                if (XMLFuncs.isAttr(lc, aid)) {
                    String name = XMLFuncs.getName(lc, aid);
                    int[] attrs = XMLFuncs.getAttrs(lc, e);
                    for (int i = 0; i < attrs.length; ++i) {
                        if (!name.equals(XMLFuncs.getName(lc, attrs[i]))) continue;
                        w.write().removeValue(e, lc.getXmlAttrProp(), i);
                        break;
                    }
                    w.write().addObject(e, lc.getXmlAttrProp(), aid);
                    continue;
                }
                if (XMLFuncs.isText(lc, aid)) {
                    w.write().addObject(e, lc.getXmlContentProp(), aid);
                    continue;
                }
                throw new RuntimeException("Argument must be an XML entity in add/1");
            }
            return ObjectId.newId(w, e);
        }
    }

    static class XTT0
    extends LibrettoFunction {
        XTT0() {
            super("tt", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int e = this.getCurrentXEntity(lc, lc.getXmlEl());
            OntCollection result = OntCC.newCol();
            XMLFuncs.getAllText(lc, result, e);
            return result;
        }
    }

    static class XT0
    extends LibrettoFunction {
        XT0() {
            super("t", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int el = this.getCurrentXEntity(lc, lc.getXmlEl());
            BoxWorker w = lc.getWorker();
            int[] sub = w.objects(el, lc.getXmlContentProp());
            OntCollection result = OntCC.newCol();
            for (int id : sub) {
                if (!RHelper.isInstanceOf(w, id, lc.getXmlText())) continue;
                result.addAllTyped(w.strings(id, lc.getXmlTextProp()));
            }
            return result;
        }
    }

    static class XA1
    extends LibrettoFunction {
        XA1() {
            super("a", 1, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int[] attr;
            int el = this.getCurrentXEntity(lc, lc.getXmlEl());
            BoxWorker w = lc.getWorker();
            String name = this.getStringArg(1);
            if (name == null) {
                throw new IllegalArgumentException("Argument value must be an XML attribute name");
            }
            for (int a : attr = w.objects(el, lc.getXmlAttrProp())) {
                String nm = w.strings(a, lc.getXmlNameProp())[0];
                if (!nm.equals(name)) continue;
                return w.strings(a, lc.getXmlValProp());
            }
            return null;
        }
    }

    static class XA0
    extends LibrettoFunction {
        XA0() {
            super("a", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int el = this.getCurrentXEntity(lc, lc.getXmlEl());
            BoxWorker w = lc.getWorker();
            int[] attr = w.objects(el, lc.getXmlAttrProp());
            return OntCC.newCol(w, attr);
        }
    }

    static class XEE0
    extends LibrettoFunction {
        XEE0() {
            super("ee", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int eId = this.getCurrentXEntity(lc, lc.getXmlEl());
            OntCollection result = OntCC.newCol();
            XMLFuncs.getAll(lc, result, null, eId);
            return result;
        }
    }

    static class XEE1
    extends LibrettoFunction {
        XEE1() {
            super("ee", 1, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int eId = this.getCurrentXEntity(lc, lc.getXmlEl());
            String name = this.getStringArg(1);
            if (name == null) {
                throw new IllegalArgumentException("Argument value must be an XML element name");
            }
            OntCollection result = OntCC.newCol();
            XMLFuncs.getAll(lc, result, name, eId);
            return result;
        }
    }

    static class XE0
    extends LibrettoFunction {
        XE0() {
            super("e", 0, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int el = this.getCurrentXEntity(lc, lc.getXmlEl());
            BoxWorker w = lc.getWorker();
            int[] sub = w.objects(el, lc.getXmlContentProp());
            OntCollection result = OntCC.newCol();
            for (int id : sub) {
                if (!XMLHelper.isElement(w, id)) continue;
                result.addObject(w, id);
            }
            return result;
        }
    }

    static class XE1
    extends LibrettoFunction {
        XE1() {
            super("e", 1, T.ELEMENT_WISE, "http://xml.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            int el = this.getCurrentXEntity(lc, lc.getXmlEl());
            BoxWorker w = lc.getWorker();
            String name = this.getStringArg(1);
            if (name == null) {
                throw new IllegalArgumentException("Argument value must be an XML element name");
            }
            int[] sub = w.objects(el, lc.getXmlContentProp());
            OntCollection result = OntCC.newCol();
            for (int subi : sub) {
                String nm;
                if (!XMLHelper.isElement(w, subi) || !(nm = w.strings(subi, lc.getXmlNameProp())[0]).equals(name)) continue;
                result.addAllTyped(ObjectId.newId(w, subi));
            }
            return result;
        }
    }
}

