/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.FunctionType;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.getchar.NameTable;
import org.ontobox.libretto.parser.Token;

public class FunctionTable
extends NameTable {
    private final ArrayList<Integer> arityArray = new ArrayList();
    private final ArrayList<FunctionDef> definitions = new ArrayList();

    public FunctionTable() {
    }

    public FunctionTable(FunctionTable functions) {
        this.nTable.putAll(functions.nTable);
        this.namesCounter = functions.namesCounter;
        this.nArray.addAll(functions.nArray);
        this.arityArray.addAll(functions.arityArray);
        for (FunctionDef def : functions.definitions) {
            if (def != null) {
                this.definitions.add(new FunctionDef(def));
                continue;
            }
            this.definitions.add(null);
        }
    }

    public int pushFunction(Token frec, String full_name, FunctionType ft) {
        int numb;
        FunctionDef fd;
        Token head = frec.getSub(0);
        if (ft == null) {
            ft = FunctionType.createUntyped(head.value);
        }
        if ((fd = this.definitions.get(numb = this.pushFunction(full_name, head.value))) == null) {
            fd = new FunctionDef(full_name, ft, frec);
            this.definitions.set(numb, fd);
        } else {
            fd.insert(ft, frec);
        }
        return numb;
    }

    public int pushFunction(LibrettoFunction mf) {
        String compname;
        int numb;
        int arity = mf.getArity();
        FunctionType ft = mf.getFType();
        if (ft == null) {
            ft = FunctionType.createUntyped(arity);
        }
        if ((numb = this.putName(compname = mf.getTitle())) < this.arityArray.size()) {
            FunctionDef fd = this.definitions.get(numb);
            fd.insert(ft, mf);
        } else {
            this.arityArray.add(numb, arity);
            FunctionDef fd = new FunctionDef(mf.getName(), ft, mf);
            this.definitions.add(numb, fd);
        }
        return numb;
    }

    public int pushFunction(LibrettoFunction mf, String types) {
        int arity = mf.getArity();
        FunctionType ft = mf.getFType();
        ft = types == null ? FunctionType.createUntyped(arity) : FunctionType.readType(arity, types);
        String compname = mf.getTitle();
        int numb = this.putName(compname);
        if (numb < this.arityArray.size()) {
            FunctionDef fd = this.definitions.get(numb);
            fd.insert(ft, mf);
        } else {
            this.arityArray.add(numb, arity);
            FunctionDef fd = new FunctionDef(mf.getName(), ft, mf);
            this.definitions.add(numb, fd);
        }
        return numb;
    }

    public int pushFunction(String name, int arity) {
        int numb = this.putName(name + '/' + arity);
        if (numb == this.arityArray.size()) {
            this.arityArray.add(numb, arity);
            this.definitions.add(numb, null);
        }
        return numb;
    }

    public int checkFunction(String name, int arity) {
        int numb = this.checkName(name + '/' + arity);
        if (numb == -1) {
            return -1;
        }
        int ar = this.arityArray.get(numb);
        if (ar != arity) {
            return -1;
        }
        return numb;
    }

    public int getArity(int numb) {
        if (numb >= 0 && numb < this.arityArray.size()) {
            return this.arityArray.get(numb);
        }
        return -1;
    }

    public FunctionDef getDefinition(int numb) {
        if (numb >= 0 && numb < this.definitions.size()) {
            return this.definitions.get(numb);
        }
        return null;
    }

    public void addFuncs(Collection<LibrettoFunction> funcs) {
        for (LibrettoFunction func : funcs) {
            this.pushFunction(func);
        }
    }

    public void addFuncs(LibrettoFunction ... funcs) {
        this.addFuncs(Arrays.asList(funcs));
    }
}

