/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.test;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import java.util.Collection;
import org.ontobox.box.BoxClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.WHelper;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;
import org.ontobox.storage.StorageBox;

public class CompilerTest {
    private static final String ONT = "http://test";
    private static final String CLASS = "http://test#cl";
    private static final String TPROP = "http://test#tprop";
    private static final int COUNT = 1000;

    public static void testQuery(BoxWorker worker, Handler handler, String str) {
        long t1 = System.nanoTime();
        Collection<Collection> ret = handler.execute(new LocalContext(handler, worker), str);
        long t2 = System.nanoTime();
        Collection collection = ret.iterator().next();
        System.out.println(str + ": " + collection.size());
        System.out.println((t2 - t1) / 1000L / 1000L + " ms");
    }

    public static void testWorkerSimple(BoxWorker worker) {
        long t1 = System.nanoTime();
        int[] objects = worker.objects(worker.resolve(CLASS, Entity.ONTCLASS));
        IntList res = CCreator.newIntList((int)16);
        int tprop = worker.resolve(TPROP, Entity.TPROPERTY);
        for (int object : objects) {
            String[] values = worker.strings(object, tprop);
            if (!RHelper.contains(values, "3") && !RHelper.contains(values, "4")) continue;
            res.add(object);
        }
        long t2 = System.nanoTime();
        System.out.println("worker (simple): " + res.size());
        System.out.println((t2 - t1) / 1000L / 1000L + " ms");
    }

    public static void testWorkerFast(BoxWorker worker) {
        long t1 = System.nanoTime();
        int tprop = worker.resolve(TPROP, Entity.TPROPERTY);
        int[] set1 = worker.owners(tprop, "3");
        int[] set2 = worker.owners(tprop, "4");
        IntSet res = CCreator.newIntSet((int)(set1.length + set2.length));
        res.addAll(set1);
        res.addAll(set2);
        long t2 = System.nanoTime();
        System.out.println("worker (fast): " + res.size());
        System.out.println((t2 - t1) / 1000L / 1000L + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StorageBox box = new StorageBox();
        try {
            box.client(new BoxClient<Object>(){

                @Override
                public Object process(BoxWorker worker) throws Exception {
                    BoxWriter writer = worker.write();
                    int ontology = writer.newOntology(CompilerTest.ONT);
                    WHelper.ontclass(worker, CompilerTest.CLASS).tprop(CompilerTest.TPROP, null);
                    for (int t = 0; t < 1000; ++t) {
                        int v = t % 100;
                        WHelper.object(worker, ontology, CompilerTest.CLASS).addInt(CompilerTest.TPROP, v).addInt(CompilerTest.TPROP, v + 1);
                    }
                    Handler handler = new Handler();
                    handler.getMapping().put("", CompilerTest.ONT);
                    CompilerTest.testQuery(worker, handler, "cl[tprop=(3,4)];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop=(3,4)];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop=3 or tprop=4];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop=3 or tprop=4];");
                    CompilerTest.testWorkerSimple(worker);
                    CompilerTest.testWorkerSimple(worker);
                    CompilerTest.testWorkerFast(worker);
                    CompilerTest.testWorkerFast(worker);
                    CompilerTest.testQuery(worker, handler, "cl[tprop];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop=1];");
                    CompilerTest.testQuery(worker, handler, "cl[tprop=1];");
                    CompilerTest.testQuery(worker, handler, "cl[not tprop=1];");
                    CompilerTest.testQuery(worker, handler, "cl[not tprop=1];");
                    return null;
                }
            });
        }
        finally {
            box.close();
        }
    }
}

