/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.libretto;

import java.io.File;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.XMLHelper;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.helper.JsonHelper;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.play.data.Global;
import play.Play;
import play.data.Upload;
import play.i18n.Lang;
import play.i18n.Messages;
import play.libs.Time;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.Scope;
import play.mvc.results.Error;
import play.mvc.results.Redirect;
import play.mvc.results.RenderBinary;
import play.mvc.results.RenderHtml;
import play.mvc.results.RenderJson;
import play.mvc.results.RenderText;
import play.mvc.results.RenderXml;

public class PlayFuncs {
    private static final Logger log = Logger.getLogger(PlayFuncs.class.getName());

    public static void init(FunctionTable funcs) {
        funcs.pushFunction(new Path1());
        funcs.pushFunction(new Path0());
        funcs.pushFunction(new URL1());
        funcs.pushFunction(new URL2());
        funcs.pushFunction(new URL0());
        funcs.pushFunction(new R0());
        funcs.pushFunction(new C0());
        funcs.pushFunction(new Redirect1());
        funcs.pushFunction(new Redirect2());
        funcs.addFuncs(new PlayF("config", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                return Play.configuration.getProperty(this.stringM(1));
            }
        }, new PlayF("int", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return PlayFuncs.toInt(this.context());
            }
        }, new PlayF("file", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return PlayFuncs.toFile(this.context());
            }
        }, new PlayF("object", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                return PlayFuncs.toObject(lc, this.context(), null);
            }
        }, new PlayF("object", 1, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                Object arg = this.arg(1);
                if (arg instanceof ObjectId) {
                    return PlayFuncs.fromObject(lc, ((ObjectId)arg).id(), null);
                }
                return PlayFuncs.toObject(lc, this.context(), LibrettoFunction.string(this.arg(1)));
            }
        }, new PlayF("object", 2, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                int obj = this.objectM(1);
                String prefix = this.stringM(2);
                return PlayFuncs.fromObject(lc, obj, prefix);
            }
        }, new PlayF("session", 0, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                BoxWorker worker = lc.getWorker();
                int idProp = worker.resolve("http://play.ontobox.org/#sessionId", Entity.TPROPERTY);
                int timeProp = worker.resolve("http://play.ontobox.org/#sessionTime", Entity.TPROPERTY);
                int[] objects = worker.objects(worker.resolve("http://play.ontobox.org/#Session", Entity.ONTCLASS));
                String expire = Scope.COOKIE_EXPIRE;
                if (expire != null) {
                    boolean deleted = false;
                    BoxWriter writer = worker.write();
                    for (int session : objects) {
                        Long ts = RHelper.longValue(worker, session, timeProp);
                        if (ts != null && ts >= System.currentTimeMillis()) continue;
                        log.info("Session " + RHelper.stringValue(worker, session, idProp) + " expired");
                        writer.delete(session);
                        deleted = true;
                    }
                    if (deleted) {
                        objects = worker.objects(worker.resolve("http://play.ontobox.org/#Session", Entity.ONTCLASS));
                    }
                }
                String id = Scope.Session.current().getId();
                for (int session : objects) {
                    if (!id.equals(RHelper.stringValue(worker, session, idProp))) continue;
                    PlayFuncs.updateSessionTime(worker, session);
                    return ObjectId.newId(worker, session);
                }
                return null;
            }
        }, new PlayF("bindSession", 0, T.ELEMENT_WISE){

            @Override
            public Object call(LocalContext lc) {
                int session = this.objectM();
                BoxWorker worker = lc.getWorker();
                int idProp = worker.resolve("http://play.ontobox.org/#sessionId", Entity.TPROPERTY);
                BoxWriter writer = worker.write();
                writer.removeValues(session, idProp);
                writer.addString(session, idProp, Scope.Session.current().getId());
                PlayFuncs.updateSessionTime(worker, session);
                return ObjectId.newId(worker, session);
            }
        }, new PlayF("lang", 0, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                return Lang.get();
            }
        }, new PlayF("msg", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                return Messages.get((Object)this.stringM(1), (Object[])new Object[0]);
            }
        }, new PlayF("renderText", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                throw new RenderText((CharSequence)this.stringM(1));
            }
        }, new PlayF("renderJson", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                BoxWorker worker = lc.getWorker();
                throw new RenderJson(JsonHelper.toJsonString(worker, this.arg(1)));
            }
        }, new PlayF("renderXml", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                Object arg;
                BoxWorker worker = lc.getWorker();
                Integer xml = 13.xml(worker, arg = this.arg(1));
                if (xml != null) {
                    StringWriter sw = new StringWriter();
                    XMLHelper.exportXML(worker, sw, (int)xml);
                    throw new RenderXml((CharSequence)sw.toString());
                }
                String str = 13.string(arg);
                if (str != null) {
                    throw new RenderXml((CharSequence)str);
                }
                throw new LibrettoFunction.WrongArg(1, "string or xml");
            }
        }, new PlayF("renderHtml", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                Object arg;
                BoxWorker worker = lc.getWorker();
                Integer xml = 14.xml(worker, arg = this.arg(1));
                if (xml != null) {
                    StringWriter sw = new StringWriter();
                    XMLHelper.exportHTML(worker, sw, xml);
                    throw new RenderHtml((CharSequence)sw.toString());
                }
                String str = 14.string(arg);
                if (str != null) {
                    throw new RenderHtml((CharSequence)str);
                }
                throw new LibrettoFunction.WrongArg(1, "string or xml");
            }
        }, new PlayF("renderBinaryFile", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                File file = new File(this.stringM(1));
                throw new RenderBinary(file);
            }
        }, new PlayF("renderBinaryFile", 2, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                File file = new File(this.stringM(1));
                throw new RenderBinary(file, this.stringM(2));
            }
        }, new PlayF("renderBinaryFileInline", 2, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                throw new RenderBinary(new File(this.stringM(1)), this.stringM(2), true);
            }
        }, new PlayF("error", 1, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                throw new Error(this.stringM(1));
            }
        }, new PlayF("error", 2, T.STATIC){

            @Override
            public Object call(LocalContext lc) {
                throw new Error(this.getIntegerM(1), this.stringM(2));
            }
        });
    }

    public static Integer toInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof String) {
            try {
                return Integer.valueOf((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object toFile(Object obj) {
        OntCollection ret = OntCC.newCol();
        if (obj instanceof String) {
            String value = (String)obj;
            List uploads = (List)Http.Request.current().args.get("__UPLOADS");
            for (Upload upload : uploads) {
                File file;
                if (!upload.getFieldName().equals(value) || (file = upload.asFile()).length() <= 0L) continue;
                ret.add(file.getAbsolutePath());
            }
        }
        return ret;
    }

    public static Object toObject(LocalContext lc, Object obj, String prefix) {
        BoxWorker worker = lc.getWorker();
        if (obj instanceof String) {
            String fullName;
            String s;
            String name = (String)obj;
            if (name.contains("#")) {
                if (worker.entity(name) == Entity.ONTOBJECT) {
                    return ObjectId.newId(worker, worker.id(name));
                }
            } else if (prefix != null && (s = lc.getHandler().getMapping().get(prefix)) != null && worker.entity(fullName = s + "#" + name) == Entity.ONTOBJECT) {
                return ObjectId.newId(worker, worker.resolve(fullName));
            }
        }
        return null;
    }

    public static Object fromObject(LocalContext lc, int obj, String prefix) {
        String s;
        String name = lc.getWorker().name(obj);
        if (prefix != null && (s = lc.getHandler().getMapping().get(prefix)) != null && name.startsWith(s + '#')) {
            return NameHelper.splitName(name).local();
        }
        return name;
    }

    private static void updateSessionTime(BoxWorker worker, int session) {
        String expire = Scope.COOKIE_EXPIRE;
        if (expire != null) {
            int prop = worker.resolve("http://play.ontobox.org/#sessionTime");
            long ts = System.currentTimeMillis() + (long)(Time.parseDuration((String)expire) * 1000);
            BoxWriter writer = worker.write();
            writer.removeValues(session, prop);
            writer.addLong(session, prop, ts);
        }
    }

    static class Redirect2
    extends LibrettoFunction {
        Redirect2() {
            super("redirect", 2, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            String path = Router.reverse((String)this.getStringM((int)1), MapHelper.toTMaps2((BoxWorker)worker, (int)this.getMapM((BoxWorker)worker, (int)2))).url;
            System.out.println("Redirect to " + path);
            throw new Redirect(path);
        }
    }

    static class Redirect1
    extends LibrettoFunction {
        Redirect1() {
            super("redirect", 1, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            String path = Router.reverse((String)this.getStringM((int)1)).url;
            System.out.println("Redirect to " + path);
            throw new Redirect(path);
        }
    }

    static class C0
    extends LibrettoFunction {
        C0() {
            super("c", 0, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            return ObjectId.newId(worker, Global.c(worker));
        }
    }

    static class R0
    extends LibrettoFunction {
        R0() {
            super("r", 0, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            return ObjectId.newId(worker, Global.r(worker));
        }
    }

    static class URL0
    extends LibrettoFunction {
        URL0() {
            super("url", 0, T.ELEMENT_WISE, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            return Router.reverse((String)this.getCurrentString()).url;
        }
    }

    static class URL1
    extends LibrettoFunction {
        URL1() {
            super("url", 1, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            return Router.reverse((String)this.getStringM((int)1)).url;
        }
    }

    static class URL2
    extends LibrettoFunction {
        URL2() {
            super("url", 2, T.STATIC, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            BoxWorker worker = lc.getWorker();
            int map = this.getMapM(worker, 2);
            return Router.reverse((String)this.getStringM((int)1), MapHelper.toTMaps2((BoxWorker)worker, (int)map)).url;
        }
    }

    static class Path0
    extends LibrettoFunction {
        Path0() {
            super("path", 0, T.ELEMENT_WISE, "http://play.ontobox.org/", null);
        }

        @Override
        public Object call(LocalContext lc) {
            return Play.getFile((String)this.getCurrentString());
        }
    }

    static class Path1
    extends PlayF {
        Path1() {
            super("path", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            return Play.getFile((String)this.getStringM(1));
        }
    }

    static abstract class PlayF
    extends LibrettoFunction {
        protected PlayF(String name, int arity, T ctxtype) {
            super(name, arity, ctxtype, "http://play.ontobox.org/", null);
        }
    }
}

