/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.test;

import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.query.FunctionInfo;
import org.ontobox.box.query.FunctionParam;
import org.ontobox.box.query.QContext;
import org.ontobox.storage.StorageBox;

public class FuncsList {
    private static void printFunc(FunctionInfo func) {
        System.out.println(func.getUri() + " # " + func.getLocal() + (func.isCollectionWise() ? "+" : ""));
        for (List<FunctionParam> params : func.getSignatures()) {
            System.out.print("\t/" + params.size() + ": ");
            for (FunctionParam param : params) {
                System.out.print(param.getName() + ":" + param.getType() + ":" + param.isCollectionWise() + ", ");
            }
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StorageBox box = new StorageBox();
        try {
            final QContext ctx = new QContext();
            box.clientRO(new BoxClient<Object>(){

                @Override
                public Object process(BoxWorker worker) throws Exception {
                    for (FunctionInfo functionInfo : ctx.getFunctions(worker, "http://ontobox.org/")) {
                        FuncsList.printFunc(functionInfo);
                    }
                    System.out.println("===============");
                    for (FunctionInfo functionInfo : ctx.getFunctions(worker, "http://xml.ontobox.org/")) {
                        FuncsList.printFunc(functionInfo);
                    }
                    for (Map.Entry entry : ctx.getPrefixes().entrySet()) {
                        System.out.println((String)entry.getKey() + "->" + (String)entry.getValue());
                    }
                    String fn = "http://ontobox.org/#string";
                    String string = ctx.shortName(fn);
                    System.out.println(string);
                    System.out.println(ctx.unshortenName(string));
                    ctx.setDefaultPrefix("http://ontobox.org/");
                    System.out.println(ctx.shortName(fn));
                    return null;
                }
            });
        }
        finally {
            box.close();
        }
    }
}

