/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.examples.fb2;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class FB2 {
    private static final SAXParserFactory factory = SAXParserFactory.newInstance();
    private static final SAXParser parser;
    private Element description;

    public FB2(InputStream in) {
        FB2Parser p = new FB2Parser();
        try {
            parser.parse(in, (DefaultHandler)p);
        }
        catch (StopParsingException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.description = p.current;
        if (this.description == null) {
            this.description = new Element("description");
        }
    }

    protected static String getChildText(Element el, String ... children) {
        for (String child : children) {
            if ((el = el.getChild(child)) != null) continue;
            return null;
        }
        return el.getTextNormalize();
    }

    protected static String getChildTextXML(Element el, String ... children) {
        for (String child : children) {
            if ((el = el.getChild(child)) != null) continue;
            return null;
        }
        return new XMLOutputter().outputString(el.getContent()).trim();
    }

    protected static List<String> getChildTexts(Element el, String ... children) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = children.length;
        int count = 0;
        List ch = null;
        for (String child : children) {
            if (count + 1 == len) {
                ch = el.getChildren(child);
            } else if ((el = el.getChild(child)) == null) {
                return ret;
            }
            ++count;
        }
        for (Object o : ch) {
            Element e = (Element)o;
            ret.add(e.getTextNormalize());
        }
        return ret;
    }

    protected static List<String[]> getPersons(List persons) {
        ArrayList<String[]> ret = new ArrayList<String[]>(persons.size());
        for (Object o : persons) {
            Element person = (Element)o;
            ret.add(new String[]{FB2.getChildText(person, "last-name"), FB2.getChildText(person, "first-name"), FB2.getChildText(person, "middle-name")});
        }
        return ret;
    }

    public List<String[]> getAuthors() {
        Element titleInfo = this.description.getChild("title-info");
        if (titleInfo != null) {
            return FB2.getPersons(titleInfo.getChildren("author"));
        }
        return Collections.emptyList();
    }

    public List<String[]> getSrcAuthors() {
        Element titleInfo = this.description.getChild("src-title-info");
        if (titleInfo != null) {
            return FB2.getPersons(titleInfo.getChildren("author"));
        }
        return Collections.emptyList();
    }

    public List<String[]> getTranslators() {
        Element titleInfo = this.description.getChild("title-info");
        if (titleInfo != null) {
            return FB2.getPersons(titleInfo.getChildren("translator"));
        }
        return Collections.emptyList();
    }

    public List<String> getGenres() {
        return FB2.getChildTexts(this.description, "title-info", "genre");
    }

    public String getTitle() {
        return FB2.getChildText(this.description, "title-info", "book-title");
    }

    public String getAnno() {
        return FB2.getChildTextXML(this.description, "title-info", "annotation");
    }

    public String getBookName() {
        return FB2.getChildText(this.description, "publish-info", "book-name");
    }

    public String getPublisher() {
        return FB2.getChildText(this.description, "publish-info", "publisher");
    }

    public String getYear() {
        return FB2.getChildText(this.description, "publish-info", "year");
    }

    public String getISBN() {
        return FB2.getChildText(this.description, "publish-info", "isbn");
    }

    public String getCity() {
        return FB2.getChildText(this.description, "publish-info", "city");
    }

    public String getKeywords() {
        return FB2.getChildTextXML(this.description, "title-info", "keywords");
    }

    public String getLang() {
        return FB2.getChildText(this.description, "title-info", "lang");
    }

    public String getSrcLang() {
        return FB2.getChildText(this.description, "title-info", "src-lang");
    }

    public String getSrcTitle() {
        return FB2.getChildText(this.description, "src-title-info", "book-title");
    }

    public String getDate() {
        return FB2.getChildText(this.description, "title-info", "date");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Authors: ");
        for (String[] stringArray : this.getAuthors()) {
            sb.append(stringArray).append(' ');
        }
        sb.append("\nTranslators: ");
        for (String[] stringArray : this.getTranslators()) {
            sb.append(stringArray).append(' ');
        }
        sb.append("\nGenres: ");
        for (String string : this.getGenres()) {
            sb.append(string).append(' ');
        }
        sb.append("\nTitle: ").append(this.getTitle());
        sb.append("\nKeywords: ").append(this.getKeywords());
        sb.append("\nBook name: ").append(this.getBookName());
        sb.append("\nPublisher: ").append(this.getPublisher());
        sb.append("\nCity: ").append(this.getCity());
        sb.append("\nYear: ").append(this.getYear());
        sb.append("\nISBN: ").append(this.getISBN());
        sb.append("\nAnno: ").append(this.getAnno());
        return sb.toString();
    }

    static {
        try {
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class FB2Parser
    extends DefaultHandler {
        private Element current;

        private FB2Parser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.current == null) {
                if (qName.equals("description")) {
                    this.current = new Element(qName);
                }
            } else {
                Element newEl = new Element(qName);
                this.current.addContent((Content)newEl);
                this.current = newEl;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.current != null) {
                this.current.addContent(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.current != null) {
                Element parent = this.current.getParentElement();
                if (parent == null) {
                    throw new StopParsingException();
                }
                this.current = parent;
            }
        }
    }

    private static class StopParsingException
    extends SAXException {
        private StopParsingException() {
        }
    }
}

