/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;

public class EqualsTestCase
extends SessionTestCase {
    private static final String NAME = "equalstest";
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualsOntClass() throws Exception {
        OntClass cl = this.ont.createOntClass(NAME, new OntClass[0]);
        try {
            OntClass cl2 = this.con.getOntClassByFullName(cl.getFullName());
            EqualsTestCase.assertTrue((boolean)cl.equals(cl2));
            EqualsTestCase.assertTrue((boolean)cl2.equals(cl));
            OntClass cl3 = this.ont.getOntClass(NAME);
            EqualsTestCase.assertTrue((boolean)cl3.equals(cl));
            EqualsTestCase.assertTrue((boolean)cl3.equals(cl2));
            EqualsTestCase.assertTrue((boolean)cl.equals(cl3));
            EqualsTestCase.assertTrue((boolean)cl2.equals(cl3));
        }
        finally {
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualsOntObject() throws Exception {
        OntObject obj1 = this.ont.createOntObject(NAME, new Object[0]);
        try {
            OntObject obj2 = this.con.getOntObjectByFullName(obj1.getFullName());
            EqualsTestCase.assertTrue((boolean)obj1.equals(obj2));
            EqualsTestCase.assertTrue((boolean)obj2.equals(obj1));
            OntObject obj3 = this.ont.getOntObject(NAME);
            EqualsTestCase.assertTrue((boolean)obj3.equals(obj1));
            EqualsTestCase.assertTrue((boolean)obj3.equals(obj2));
            EqualsTestCase.assertTrue((boolean)obj1.equals(obj3));
            EqualsTestCase.assertTrue((boolean)obj2.equals(obj3));
        }
        finally {
            obj1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualsOProperty() throws Exception {
        OProperty prop1 = this.ont.createOProperty(NAME, null, null, null, null);
        try {
            OProperty prop2 = this.con.getOPropertyByFullName(prop1.getFullName());
            EqualsTestCase.assertTrue((boolean)prop1.equals(prop2));
            EqualsTestCase.assertTrue((boolean)prop2.equals(prop1));
            OProperty prop3 = this.ont.getOProperty(NAME);
            EqualsTestCase.assertTrue((boolean)prop3.equals(prop1));
            EqualsTestCase.assertTrue((boolean)prop3.equals(prop2));
            EqualsTestCase.assertTrue((boolean)prop1.equals(prop3));
            EqualsTestCase.assertTrue((boolean)prop2.equals(prop3));
        }
        finally {
            prop1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEqualsTProperty() throws Exception {
        TProperty prop1 = this.ont.createTProperty(NAME, null, null, null, null);
        try {
            TProperty prop2 = this.con.getTPropertyByFullName(prop1.getFullName());
            EqualsTestCase.assertTrue((boolean)prop1.equals(prop2));
            EqualsTestCase.assertTrue((boolean)prop2.equals(prop1));
            TProperty prop3 = this.ont.getTProperty(NAME);
            EqualsTestCase.assertTrue((boolean)prop3.equals(prop1));
            EqualsTestCase.assertTrue((boolean)prop3.equals(prop2));
            EqualsTestCase.assertTrue((boolean)prop1.equals(prop3));
            EqualsTestCase.assertTrue((boolean)prop2.equals(prop3));
        }
        finally {
            prop1.delete();
        }
    }
}

