/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.server;

import com.teacode.bml.BML;
import com.teacode.bml.DefaultSizedListIterator;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meta2project.model.Connection;
import org.meta2project.model.OntObject;
import org.meta2project.model.Session;
import org.ontobox.libretto.Handler;
import org.ontobox.libretto.LocalContext;

public class UserContext {
    private static final Logger logger = Logger.getLogger(UserContext.class.getName());
    private static final String ERROR_DATA = "error";
    private static final String RESULT_DATA = "result";
    private static final String NS_DATA = "ns";
    private static final String QUERY_DATA = "query";
    private static final String RAW_TIME_DATA = "raw-time";
    private final Session session;
    private final Handler handler;

    public UserContext(Session session) {
        this.session = session;
        this.handler = new Handler();
    }

    public synchronized void executeQuery(String query, OutputStream out) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put(ERROR_DATA, null);
        data.put(RESULT_DATA, null);
        data.put(NS_DATA, null);
        data.put(QUERY_DATA, query);
        data.put(RAW_TIME_DATA, null);
        Connection con = this.session.openTransaction();
        try {
            long t1 = System.currentTimeMillis();
            Collection<Collection> result = this.handler.execute(new LocalContext(this.handler, con.getWorker()), query);
            long t2 = System.currentTimeMillis();
            data.put(RAW_TIME_DATA, t2 - t1);
            data.put(RESULT_DATA, new DefaultSizedListIterator<Object>(result){

                protected Object process(Object o) {
                    return new DefaultSizedListIterator<Object>((Collection)o){

                        protected Object process(Object o) {
                            if (o == null) {
                                return null;
                            }
                            if (o instanceof OntObject) {
                                return ((OntObject)o).getFullName();
                            }
                            return o.toString();
                        }
                    };
                }
            });
            data.put(NS_DATA, this.handler.getMapping());
            BML.save(data, (OutputStream)out);
            con.close();
        }
        catch (Exception e) {
            con.closeRollback();
            logger.log(Level.WARNING, "ontobox client error", e);
            String msg = e.getMessage().trim();
            if (msg.isEmpty()) {
                msg = e.toString();
            }
            data.put(ERROR_DATA, msg);
            BML.save(data, (OutputStream)out);
        }
    }
}

