/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.SplittedName;

public class NameHelper {
    public static SplittedName splitName(String fullName) {
        int t = 0;
        int len = fullName.length();
        StringBuilder sb = new StringBuilder(100);
        while (true) {
            char ch;
            if (t >= len) {
                return null;
            }
            if ((ch = fullName.charAt(t++)) == '#') break;
            sb.append(ch);
        }
        String uri = sb.toString();
        sb.setLength(0);
        while (t < len) {
            sb.append(fullName.charAt(t++));
        }
        return new SplittedName(uri, sb.toString());
    }

    public static String getShortOntologyName(String uri) {
        try {
            String name;
            int i;
            if (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if ((i = uri.lastIndexOf(47)) != -1 && (name = uri.substring(i + 1).trim()).length() != 0) {
                return name;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public static boolean isSystemOntology(String uri) {
        return uri.startsWith("http://ontobox.org");
    }

    public static Map<String, String> generatePrefixes(BoxWorker worker, Map<String, String> alreadyDefined) {
        HashMap<String, String> ret = new HashMap<String, String>(alreadyDefined);
        HashSet alreadySet = new HashSet(ret.values());
        ArrayList<String> uris = new ArrayList<String>();
        int maxObjectCount = 0;
        int maxObjectOnt = -1;
        for (int ont : worker.ontologies()) {
            int objCount;
            String uri = worker.name(ont);
            if (alreadySet.contains(uri)) continue;
            uris.add(uri);
            if (NameHelper.isSystemOntology(uri) || maxObjectCount >= (objCount = worker.objects(ont).length)) continue;
            maxObjectCount = objCount;
            maxObjectOnt = ont;
        }
        if (ret.get("") != null) {
            maxObjectOnt = -1;
        }
        Collections.sort(uris);
        block1: for (String uri : uris) {
            String shortName;
            shortName = maxObjectOnt == worker.id(uri) ? "" : ((shortName = NameHelper.getShortOntologyName(uri)).isEmpty() || shortName.startsWith("http://") ? "ont" : (shortName.length() <= 3 ? shortName.toLowerCase() : shortName.substring(0, 3).toLowerCase()));
            if (!ret.containsKey(shortName)) {
                ret.put(shortName, uri);
                continue;
            }
            int t = 2;
            while (true) {
                String n;
                if (!ret.containsKey(n = shortName + t)) {
                    ret.put(n, uri);
                    continue block1;
                }
                ++t;
            }
        }
        return ret;
    }
}

