/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box64.test;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntIntMap;
import com.teacode.collection.primitive.ObjectIntMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.ontobox.box64.test.BaseMapper;

public class DiskMapper
extends BaseMapper {
    private int counter = 0;
    private final Charset charset = Charset.forName("UnicodeBigUnmarked");
    private final RandomAccessFile raf;
    private final IntIntMap idName = CCreator.newIntIntMap((int)200);
    private final ObjectIntMap<String> nameId = CCreator.newObjectIntMap((int)200);

    public DiskMapper() throws FileNotFoundException {
        File file = new File("diskmapper.data");
        this.raf = new RandomAccessFile(file, "rw");
    }

    public int name(String name) throws IOException {
        Integer id = this.nameId.get((Object)name);
        if (id != null) {
            return id;
        }
        int i = this.counter++;
        this.nameId.put((Object)name, i);
        this.idName.put(i, (int)this.raf.getFilePointer());
        this.raf.write(name.getBytes(this.charset));
        return i;
    }

    @Override
    public void addObject(String ont, String local) throws IOException {
        int ontId = this.name(ont);
        int objId = this.name(ont + "#" + local);
        this.addObject(ontId, objId);
    }

    @Override
    public void test() throws IOException {
        System.out.println(this.raf.getFilePointer());
        super.test();
    }

    @Override
    public int id(String fn) {
        return this.nameId.get((Object)fn);
    }
}

