/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.Collection;
import org.ontobox.box.event.AddSubclassEvent;
import org.ontobox.fast.action.RemoveSubclass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class AddSubclass
implements WriteAction,
AddSubclassEvent {
    private final String superName;
    private final String subName;
    private final Collection<String> oldSuperNames = new ArrayList<String>();

    public AddSubclass(String[] data) {
        this(data[0], data[1]);
    }

    public AddSubclass(String superName, String subName) {
        this.superName = superName;
        this.subName = subName;
    }

    @Override
    public final void preverify(Storage storage) {
        if (this.superName.equals(this.subName)) {
            throw new IllegalArgumentException("Class cannot be subclass of yourself");
        }
        storage.verifyExistentClass(this.superName);
        storage.verifyExistentClass(this.subName);
        if (storage.subclasses.getDirect(storage.id(this.superName)).contains(storage.id(this.subName).intValue())) {
            throw new IllegalArgumentException(this.subName + " is already direct subclass of " + this.superName);
        }
        if (storage.getAllSuperclasses(storage.id(this.superName)).contains(storage.id(this.subName).intValue())) {
            throw new IllegalArgumentException("Class hierarchy cycle detected");
        }
    }

    @Override
    public final void doAction(final Storage storage) {
        int subId = storage.id(this.subName);
        storage.subclasses.getReverse(subId).forEach(new IntProcessor(){

            public boolean process(int i) {
                AddSubclass.this.oldSuperNames.add(storage.name(i));
                return true;
            }
        });
        storage.subclasses.add(storage.id(this.superName), subId);
        storage.dropStructureCache();
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.superName, this.subName};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new RemoveSubclass(this.superName, this.subName);
    }

    @Override
    public final String getSuperName() {
        return this.superName;
    }

    @Override
    public final String getSubName() {
        return this.subName;
    }

    @Override
    public final Collection<String> getOldSuperNames() {
        return this.oldSuperNames;
    }
}

