/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntCollection;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.Collection;
import org.ontobox.box.event.RemoveObjectClassEvent;
import org.ontobox.fast.action.AddObjectClass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class RemoveObjectClass
implements WriteAction,
RemoveObjectClassEvent {
    private final String name;
    private final String className;
    private final Collection<String> newClassNames = new ArrayList<String>();

    public RemoveObjectClass(String[] data) {
        this(data[0], data[1]);
    }

    public RemoveObjectClass(String name, String className) {
        this.name = name;
        this.className = className;
    }

    @Override
    public final void preverify(final Storage storage) {
        storage.verifyExistentObject(this.name);
        storage.verifyExistentClass(this.className);
        Integer cl = storage.id(this.className);
        final Integer object = storage.id(this.name);
        if (!storage.objectClasses.getDirect(object).contains(cl.intValue())) {
            throw new IllegalArgumentException("object " + this.name + " is not classed by " + this.className);
        }
        RemoveObjectClass.verifyRange(storage, object, cl);
        RemoveObjectClass.verifyDomain(storage, object, cl);
        storage.getAllSubclasses(cl).forEach(new IntProcessor(){

            public boolean process(int c) {
                RemoveObjectClass.verifyRange(storage, object, c);
                RemoveObjectClass.verifyDomain(storage, object, c);
                return true;
            }
        });
    }

    private static void verifyRange(final Storage storage, final int obj, final int cl) {
        IntSet oprops = storage.opropRange.getReverse(cl);
        oprops.forEach(new IntProcessor(){

            public boolean process(int oprop) {
                IntSet owners;
                BMapIntIntLazy ov = (BMapIntIntLazy)storage.ovalues.get(oprop);
                if (ov != null && !(owners = ov.getReverse(obj)).isEmpty()) {
                    throw new IllegalStateException("The object is an object value of an o-property.\nOwner:" + storage.names((IntCollection)owners) + "\n" + "O-property:" + storage.name(oprop) + "\n" + "O-property range: " + storage.name(cl) + "\n" + "Object value (the object): " + storage.name(obj) + "\n" + "That value must be removed before removing the object from class.");
                }
                return true;
            }
        });
    }

    private static void verifyDomain(final Storage storage, final int obj, final int cl) {
        IntSet oprops = storage.opropDomain.getReverse(cl);
        oprops.forEach(new IntProcessor(){

            public boolean process(int oprop) {
                IntList values;
                BMapIntIntLazy ov = (BMapIntIntLazy)storage.ovalues.get(oprop);
                if (ov != null && !(values = ov.getDirect(obj)).isEmpty()) {
                    throw new IllegalStateException("The object has an o-property value.\nObject: " + storage.name(obj) + "\n" + "O-property:" + storage.name(oprop) + "\n" + "Object value:" + storage.names((IntCollection)values) + "\n" + "O-property domain: " + storage.name(cl) + "\n" + "That value must be removed before removing the object from the class.");
                }
                return true;
            }
        });
        IntSet tprops = storage.tpropDomain.getReverse(cl);
        tprops.forEach(new IntProcessor(){

            public boolean process(int tprop) {
                BMapInt ov = storage.getValueMap(tprop);
                if (ov != null && ov.getDirectSize(obj) != 0) {
                    throw new IllegalStateException("The object has a t-property value.\nObject: " + storage.name(obj) + "\n" + "T-property: " + storage.name(tprop) + "\n" + "T-property domain: " + storage.name(cl) + "\n" + "That value must be removed before removing the object from the class.");
                }
                return true;
            }
        });
    }

    @Override
    public final void doAction(final Storage storage) {
        int id = storage.id(this.name);
        int index = storage.objectClasses.getDirect(id).indexOf(0, storage.id(this.className).intValue());
        storage.objectClasses.removeDirect(id, index);
        storage.objectClasses.getDirect(id).forEach(new IntProcessor(){

            public boolean process(int i) {
                RemoveObjectClass.this.newClassNames.add(storage.name(i));
                return true;
            }
        });
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.className};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new AddObjectClass(this.name, this.className);
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final String getClassName() {
        return this.className;
    }

    @Override
    public final Collection<String> getNewClassNames() {
        return this.newClassNames;
    }
}

