/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.id;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.ObjectIntMap;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import java.util.logging.Logger;
import org.ontobox.fast.id.IdSupport;

public class IdSimpleSupport
implements IdSupport {
    private static Logger logger = Logger.getLogger(IdSimpleSupport.class.getName());
    private int nameCounter = 0;
    private final ObjectIntMap<String> namesId = CCreator.newObjectIntMap((int)100000);
    private final IntObjectMap<String> idNames = CCreator.newIntObjectMap((int)100000);

    @Override
    public final void refreshCounter() {
        if (!this.idNames.isEmpty()) {
            final int[] max = new int[]{0};
            this.idNames.forEachEntry((IntObjectProcessor)new IntObjectProcessor<String>(){

                public boolean process(int i, String s) {
                    if (i > max[0]) {
                        max[0] = i;
                    }
                    return true;
                }
            });
            this.nameCounter = max[0] + 1;
        } else {
            this.nameCounter = 0;
        }
    }

    @Override
    public final int createName(String name) {
        if (this.namesId.containsKey((Object)name)) {
            throw new IllegalStateException("Name " + name + " already exist");
        }
        if (this.nameCounter == Integer.MAX_VALUE) {
            throw new IllegalStateException("Too many operations, the OntoBox Storage must be restarted");
        }
        int id = this.nameCounter++;
        this.addName(id, name);
        return id;
    }

    @Override
    public final void addName(int id, String name) {
        this.namesId.put((Object)name, id);
        this.idNames.put(id, (Object)name);
    }

    @Override
    public final Integer id(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return this.namesId.get((Object)name);
    }

    @Override
    public final String name(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        return (String)this.idNames.get(id.intValue());
    }

    @Override
    public final void changeName(String name, String newName) {
        int id = this.namesId.get((Object)name);
        this.namesId.removeKey((Object)name);
        this.namesId.put((Object)newName, id);
        this.idNames.put(id, (Object)newName);
    }

    @Override
    public final int deleteName(String name) {
        Integer id = this.namesId.get((Object)name);
        if (id == null) {
            throw new IllegalStateException("Unknown id for name " + name);
        }
        this.namesId.removeKey((Object)name);
        this.idNames.removeKey(id.intValue());
        return id;
    }

    @Override
    public final boolean forEachName(ObjectProcessor<String> processor) {
        return this.namesId.forEachKey(processor);
    }

    @Override
    public final boolean forEachIdName(IntObjectProcessor<String> processor) {
        return this.idNames.forEachEntry(processor);
    }

    @Override
    public final int size() {
        return this.idNames.size();
    }
}

