/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.fast.storage.DiskWorker;

class JournalCleaner
extends Thread {
    private static final Logger logger = Logger.getLogger(JournalCleaner.class.getName());
    private final DiskWorker disk;
    private static final int SLEEP_TIME_MS = 600000;
    private static final int TOO_MANY_ACTIONS_NUMBER = 2000000;

    public JournalCleaner(DiskWorker disk) {
        super("journal cleaner");
        this.disk = disk;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Thread.sleep(600000L);
                int totalActions = this.disk.journal.getTotalActions();
                logger.info("Total journal actions: " + String.valueOf(totalActions));
                if (totalActions <= 2000000) continue;
                logger.info("cleaning");
                this.disk.cleanup();
            }
        }
        catch (InterruptedException e) {
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "closing error", e);
        }
    }

    public void close() throws InterruptedException {
        this.interrupt();
        this.join();
    }
}

