/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.test;

import java.io.File;
import java.util.HashSet;
import java.util.Random;
import org.ontobox.fast.dmap.DMap;
import org.ontobox.fast.dmap.onefile.OFileDMap;

public class DMapDirectTest {
    private static final int BLOCK_SIZE = 50000;
    private static final int NUMBER = 5000;
    private static final Random rnd = new Random();

    private static DMap create() {
        File dir = new File("var-test");
        OFileDMap ret = new OFileDMap();
        ret.start(dir);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        HashSet<String> keys = new HashSet<String>(5000);
        long t1 = System.currentTimeMillis();
        DMap dmap = DMapDirectTest.create();
        try {
            t1 = System.currentTimeMillis();
            for (int t = 0; t < 5000; ++t) {
                if (t % 100 == 0) {
                    System.out.println(t);
                }
                keys.add(dmap.addValue(DMapDirectTest.generateString()));
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Created: " + (t2 - t1) + " ms");
        }
        finally {
            dmap.close(keys);
        }
        System.out.println("Total: " + (System.currentTimeMillis() - t1) + " ms");
        t1 = System.currentTimeMillis();
        dmap = DMapDirectTest.create();
        try {
            int t = 0;
            for (String key : keys) {
                if (t % 100 == 0) {
                    System.out.println("get " + t);
                }
                ++t;
                String v = dmap.get(key);
                if (v != null && v.length() == 50000) continue;
                System.out.println("Invalid value for: " + key + " <" + v + "> " + v.length());
            }
        }
        finally {
            dmap.close(keys);
        }
        System.out.println("Total: " + (System.currentTimeMillis() - t1) + " ms");
    }

    private static String generateString() {
        StringBuilder sb = new StringBuilder(50000);
        for (int t = 0; t < 50000; ++t) {
            sb.append((char)(rnd.nextInt(10) + 48));
        }
        return sb.toString();
    }
}

