/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.test;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.process.IntProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.ontobox.box.BoxDirectClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.box2model.BoxConnection;
import org.ontobox.box.helper.Values;
import org.ontobox.box.query.QContext;
import org.ontobox.exchange.MVX;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.storage.StorageBox;

public class Taxonomy {
    private static final String ONT = "http://tasks.teacode.com/";
    private static final String PARENT = "http://tasks.teacode.com/#parent";

    private static long getUsedMemory() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        return rt.totalMemory() - rt.freeMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        long m1 = Taxonomy.getUsedMemory();
        long t1 = System.currentTimeMillis();
        StorageBox box = new StorageBox(new File(new File("onto"), "tax"));
        System.out.println("load1 time: " + (System.currentTimeMillis() - t1) + " ms");
        try {
            BoxWorker worker = box.work();
            System.out.println("load2 time: " + (System.currentTimeMillis() - t1) + " ms");
            try {
                worker.write().require("http://xml.ontobox.org/");
                worker.commit();
                if (worker.entity(ONT) != Entity.ONTOLOGY) {
                    long t2 = System.currentTimeMillis();
                    MVX.importFile(new File("m2v1\\taxonomy.m2v1"), worker);
                    worker.commit();
                    System.out.println("import time: " + (System.currentTimeMillis() - t2) + " ms");
                }
                long m2 = Taxonomy.getUsedMemory();
                System.out.println("Memory: " + (m2 - m1) / 1024L / 1024L + "MB");
                Taxonomy.testSpeed(worker);
            }
            finally {
                worker.close();
            }
        }
        finally {
            t1 = System.currentTimeMillis();
            box.close();
            System.out.println("closing time: " + (System.currentTimeMillis() - t1) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeCSV(File file, List<String> v) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        try {
            boolean first = true;
            for (String s : v) {
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                writer.write(s);
            }
            writer.write(10);
        }
        finally {
            writer.close();
        }
    }

    private static void testSpeed(BoxWorker worker) throws IOException {
        File file = new File("speed.csv");
        Test[] tests = new Test[]{new TestDirect(), new TestDirectCompiled(), new TestBox(), new TestModel(), new TestQuery()};
        ArrayList<String> list = new ArrayList<String>();
        list.add("Depth");
        list.add("Count");
        for (Test test : tests) {
            list.add(test.toString());
        }
        Taxonomy.writeCSV(file, list);
        for (int t = 0; t < 3; ++t) {
            list.clear();
            int result = -1;
            list.add(String.valueOf(t));
            for (Test test : tests) {
                long t1 = System.nanoTime();
                int r = test.test(worker, t);
                long t2 = System.nanoTime();
                if (result == -1) {
                    result = r;
                    list.add(String.valueOf(r));
                    System.out.println();
                    System.out.println(t + " => " + r);
                }
                long time = (t2 - t1) / 1000L / 1000L;
                System.out.println(test + ": " + time + " ms" + (r != result ? ", wrong result " + r : ""));
                list.add(String.valueOf(time));
            }
            Taxonomy.writeCSV(file, list);
        }
    }

    static class TestDirectCompiled
    implements Test {
        TestDirectCompiled() {
        }

        @Override
        public int test(BoxWorker worker, int depth) {
            return 0;
        }

        public String toString() {
            return "Direct-Compiled";
        }
    }

    static class TestQuery
    implements Test {
        private static QContext ctx = new QContext();

        TestQuery() {
        }

        @Override
        public int test(BoxWorker worker, int depth) {
            StringBuilder sb = new StringBuilder("f:*");
            for (int t = 0; t < depth; ++t) {
                sb.append("/f:parent");
            }
            sb.append(";");
            Values result = worker.qValues(ctx, sb.toString());
            return result.size();
        }

        public String toString() {
            return "Query";
        }

        static {
            ctx.setPrefix("f", Taxonomy.ONT);
        }
    }

    static class TestBox
    implements Test {
        TestBox() {
        }

        @Override
        public int test(final BoxWorker worker, int depth) {
            final int parentProperty = worker.id(Taxonomy.PARENT);
            IntList collection = CCreator.newIntList((int)16);
            for (int ontology : worker.ontologies()) {
                collection.addAll(worker.objects(ontology));
            }
            IntList newCol = CCreator.newIntList((int)16);
            for (int t = 0; t < depth; ++t) {
                newCol.clear();
                final IntList finalNewCol = newCol;
                collection.forEach(new IntProcessor(){

                    public boolean process(int i) {
                        finalNewCol.addAll(worker.objects(i, parentProperty));
                        return true;
                    }
                });
                IntList tmp = collection;
                collection = newCol;
                newCol = tmp;
            }
            return collection.size();
        }

        public String toString() {
            return "Box";
        }
    }

    static class TestModel
    implements Test {
        TestModel() {
        }

        @Override
        public int test(BoxWorker worker, int depth) {
            BoxConnection con = new BoxConnection(worker);
            OProperty parentProperty = con.getOPropertyByFullName(Taxonomy.PARENT);
            ArrayList<OntObject> collection = new ArrayList<OntObject>();
            for (Ontology ontology : con.getOntologies()) {
                collection.addAll(ontology.getAllOntObjects());
            }
            ArrayList<OntObject> newCol = new ArrayList<OntObject>();
            for (int t = 0; t < depth; ++t) {
                newCol.clear();
                for (OntObject ontObject : collection) {
                    newCol.addAll(ontObject.getOPropertyValues(parentProperty));
                }
                ArrayList<OntObject> tmp = collection;
                collection = newCol;
                newCol = tmp;
            }
            return collection.size();
        }

        public String toString() {
            return "Model";
        }
    }

    static class TestDirect
    implements Test {
        TestDirect() {
        }

        @Override
        public int test(BoxWorker worker, final int depth) {
            return worker.clientDirect(new BoxDirectClient<Integer>(){

                @Override
                public Integer process(Storage storage) throws Exception {
                    Integer propId = storage.id(Taxonomy.PARENT);
                    int[] ints = storage.objects.directKeySet();
                    IntList collection = CCreator.newIntList((int)ints.length);
                    collection.addAll(ints);
                    IntList newCol = CCreator.newIntList((int)16);
                    for (int t = 0; t < depth; ++t) {
                        final BMapIntIntLazy map = (BMapIntIntLazy)storage.ovalues.get(propId.intValue());
                        newCol.clear();
                        final IntList finalCol = newCol;
                        final IntProcessor addAll = new IntProcessor(){

                            public boolean process(int i) {
                                finalCol.add(i);
                                return true;
                            }
                        };
                        collection.forEach(new IntProcessor(){

                            public boolean process(int i) {
                                map.getDirect(i).forEach(addAll);
                                return true;
                            }
                        });
                        IntList tmp = collection;
                        collection = newCol;
                        newCol = tmp;
                    }
                    return collection.size();
                }
            });
        }

        public String toString() {
            return "Direct";
        }
    }

    static interface Test {
        public int test(BoxWorker var1, int var2);
    }
}

