/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser.sql;

import java.util.HashMap;
import java.util.Map;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.parser.sql.SQLKey;
import org.ontobox.libretto.parser.sql.SQLToken;
import org.ontobox.libretto.parser.sql.SQLType;

class SQLTokens {
    private CharStream in;
    private static final Map<String, SQLKey> keywords = new HashMap<String, SQLKey>();

    public void setInput(CharStream input) {
        this.in = input;
    }

    SQLToken getNext() {
        if (this.in.isFirstNameLetter() || this.in.ch == '`') {
            return this.getName();
        }
        if (this.in.isQuote() || this.in.isDoubleQuote()) {
            return new SQLToken(SQLType.STRING, this.in.getString());
        }
        if (this.in.isDigit() || this.in.ch == '-') {
            Object num;
            if (this.in.ch == '0') {
                this.in.nextChk();
                if (this.in.ch == 'x') {
                    this.in.nextChk();
                    StringBuilder sb = new StringBuilder();
                    sb.append("0x");
                    char c = Character.toLowerCase(this.in.ch);
                    while (this.in.isDigit() || c >= 'a' && c <= 'f') {
                        sb.append(c);
                        this.in.nextChk();
                        c = Character.toLowerCase(this.in.ch);
                    }
                    if (sb.length() == 2) {
                        throw new RuntimeException("Empty BLOB");
                    }
                    SQLToken blob = new SQLToken(SQLType.LONGBLOB);
                    blob.name = sb.toString();
                    this.in.eatSpacesChk();
                    return blob;
                }
                if (!this.in.isDigit()) {
                    this.in.eatSpacesChk();
                    return new SQLToken(0);
                }
            }
            if ((num = this.in.getNumber()) instanceof Integer) {
                return new SQLToken((Integer)num);
            }
            return new SQLToken((Double)num);
        }
        if (this.in.ch == ',') {
            this.in.nextValidChk();
            return new SQLToken(SQLType.COMMA);
        }
        if (this.in.ch == ';') {
            this.in.nextValidChk();
            return new SQLToken(SQLType.SEMICOLON);
        }
        if (this.in.ch == '(') {
            this.in.nextValidChk();
            return new SQLToken(SQLType.LPAR);
        }
        if (this.in.ch == ')') {
            this.in.nextValidChk();
            return new SQLToken(SQLType.RPAR);
        }
        if (this.in.ch == '/') {
            this.in.nextChk();
            if (this.in.ch != '*') {
                throw new RuntimeException("Misplaced '/'");
            }
            while (true) {
                this.in.nextChk();
                if (this.in.ch != '*') continue;
                this.in.nextChk();
                if (this.in.ch == '/') break;
            }
            this.in.nextValidChk();
            return this.getNext();
        }
        if (this.in.isEndOfStream()) {
            return new SQLToken(SQLType.EOF);
        }
        throw new RuntimeException("Invalid symbol '" + this.in.ch + '\'');
    }

    SQLToken getName() {
        boolean backquote = false;
        if (this.in.ch == '`') {
            backquote = true;
            this.in.nextChk();
        }
        StringBuilder identChars = new StringBuilder();
        identChars.setLength(0);
        do {
            identChars.append(this.in.ch);
            this.in.next();
        } while (this.in.isNextNameLetter() || this.in.isColon());
        String name = identChars.toString().toLowerCase();
        this.in.eatSpacesChk();
        if (backquote) {
            if (this.in.ch != '`') {
                throw new RuntimeException("Something wrong with back quotes");
            }
            this.in.nextValidChk();
            return new SQLToken(name);
        }
        if (name.equals("null")) {
            return new SQLToken(SQLType.NULL);
        }
        if (keywords.containsKey(name)) {
            return new SQLToken(keywords.get(name));
        }
        return new SQLToken(name);
    }

    static {
        keywords.put("create", SQLKey.CREATE);
        keywords.put("table", SQLKey.TABLE);
        keywords.put("insert", SQLKey.INSERT);
        keywords.put("integer", SQLKey.INTEGER);
        keywords.put("float", SQLKey.FLOAT);
        keywords.put("blob", SQLKey.BLOB);
        keywords.put("longblob", SQLKey.LONGBLOB);
        keywords.put("datetime", SQLKey.DATETIME);
        keywords.put("smallint", SQLKey.SMALLINT);
        keywords.put("varchar", SQLKey.VARCHAR);
        keywords.put("values", SQLKey.VALUES);
        keywords.put("into", SQLKey.INTO);
        keywords.put("commit", SQLKey.COMMIT);
    }
}

