/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play;

import java.io.File;
import org.ontobox.play.LibrettoController;
import org.ontobox.play.java.JavaGenerator;
import org.ontobox.play.view.LibrettoTemplate;
import play.Play;
import play.PlayPlugin;
import play.templates.Template;
import play.vfs.VirtualFile;

public class LibrettoPlugin
extends PlayPlugin {
    protected static final String APP_CONTROLLERS = "app/controllers";
    protected JavaGenerator generator;
    protected int lastHash = -1;

    public void onLoad() {
        this.generator = new JavaGenerator();
        this.generateJavas();
    }

    public void beforeInvocation() {
        LibrettoController.closeWorkers();
    }

    public void afterInvocation() {
        LibrettoController.commitWorkers();
    }

    public void invocationFinally() {
        LibrettoController.closeWorkers();
    }

    public void detectChange() {
        int hash = LibrettoPlugin.scanLTT();
        if (hash != this.lastHash) {
            this.lastHash = hash;
            this.generateJavas();
            throw new RuntimeException("Reload!");
        }
    }

    protected static boolean isLTT(File file) {
        return file.isFile() && file.getName().toLowerCase().endsWith(".ltt");
    }

    protected static int scanLTT() {
        StringBuilder allFiles = new StringBuilder();
        for (File dir : Play.getFile((String)APP_CONTROLLERS).listFiles()) {
            if (!dir.isDirectory()) continue;
            for (File file : dir.listFiles()) {
                if (!LibrettoPlugin.isLTT(file)) continue;
                allFiles.append(file.getAbsolutePath());
            }
        }
        return allFiles.toString().hashCode();
    }

    protected void generateJavas() {
        this.generator.cleanUp();
        StringBuilder allFiles = new StringBuilder();
        for (File dir : Play.getFile((String)APP_CONTROLLERS).listFiles()) {
            if (!dir.isDirectory()) continue;
            StringBuilder methodBody = new StringBuilder();
            for (File file : dir.listFiles()) {
                if (!LibrettoPlugin.isLTT(file)) continue;
                allFiles.append(file.getAbsolutePath());
                String name = file.getName();
                int t = name.lastIndexOf(".");
                if (t != -1) {
                    name = name.substring(0, t);
                }
                methodBody.append(JavaGenerator.generateMethodQuery(name, file));
            }
            if (methodBody.length() == 0) continue;
            this.generator.generateJava(dir.getName(), methodBody.toString());
        }
        this.lastHash = allFiles.toString().hashCode();
    }

    public Template loadTemplate(VirtualFile file) {
        if (file.getName().toLowerCase().endsWith(".ltt")) {
            return new LibrettoTemplate(file);
        }
        return null;
    }
}

