/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.meta2project.model.event.ListenerManager;
import org.meta2project.model.event.NamedEntityListener;
import org.meta2project.model.event.NamedEntityRenamedEvent;
import org.meta2project.model.event.OPropertyEvent;
import org.meta2project.model.event.OPropertyListener;
import org.meta2project.model.event.OntClassEvent;
import org.meta2project.model.event.OntClassListener;
import org.meta2project.model.event.OntObjectEvent;
import org.meta2project.model.event.OntObjectListener;
import org.meta2project.model.event.OntoListener;
import org.meta2project.model.event.OntologyEvent;
import org.meta2project.model.event.OntologyRenamedEvent;
import org.meta2project.model.event.TPropertyEvent;
import org.meta2project.model.event.TPropertyListener;

public class DefaultListenerManager
implements ListenerManager {
    private final List<OntClassListener> ontClassListeners = new LinkedList<OntClassListener>();
    private final List<OPropertyListener> oPropertyListeners = new LinkedList<OPropertyListener>();
    private final List<TPropertyListener> tPropertyListeners = new LinkedList<TPropertyListener>();
    private final List<OntoListener> ontoListeners = new LinkedList<OntoListener>();
    private final List<OntObjectListener> ontObjectListeners = new LinkedList<OntObjectListener>();
    private final List<NamedEntityListener> namedEntityListeners = new LinkedList<NamedEntityListener>();

    @Override
    public void addOntClassListener(OntClassListener ontClassListener) {
        this.ontClassListeners.add(0, ontClassListener);
    }

    @Override
    public void removeOntClassListener(OntClassListener ontClassListener) {
        this.ontClassListeners.remove(ontClassListener);
    }

    @Override
    public void addOPropertyListener(OPropertyListener oPropertyListener) {
        this.oPropertyListeners.add(0, oPropertyListener);
    }

    @Override
    public void removeOPropertyListener(OPropertyListener oPropertyListener) {
        this.oPropertyListeners.remove(oPropertyListener);
    }

    @Override
    public void addTPropertyListener(TPropertyListener tPropertyListener) {
        this.tPropertyListeners.add(0, tPropertyListener);
    }

    @Override
    public void removeTPropertyListener(TPropertyListener tPropertyListener) {
        this.tPropertyListeners.remove(tPropertyListener);
    }

    @Override
    public void addOntoListener(OntoListener ontoListener) {
        this.ontoListeners.add(0, ontoListener);
    }

    @Override
    public void removeOntoListener(OntoListener ontoListener) {
        this.ontoListeners.remove(ontoListener);
    }

    @Override
    public void addOntObjectListener(OntObjectListener ontObjectListener) {
        this.ontObjectListeners.add(0, ontObjectListener);
    }

    @Override
    public void removeOntObjectListener(OntObjectListener ontObjectListener) {
        this.ontObjectListeners.remove(ontObjectListener);
    }

    @Override
    public void addNamedEntityListener(NamedEntityListener listener) {
        this.namedEntityListeners.add(0, listener);
    }

    @Override
    public void removeNamedEntityListener(NamedEntityListener listener) {
        this.namedEntityListeners.remove(listener);
    }

    public void fireOntClassCreated(String URI2, String name) {
        OntClassEvent event = new OntClassEvent(URI2, name);
        for (OntClassListener listener : this.ontClassListeners) {
            listener.ontClassCreated(event);
        }
    }

    public void fireOntClassDeleted(String URI2, String name) {
        OntClassEvent event = new OntClassEvent(URI2, name);
        for (OntClassListener listener : this.ontClassListeners) {
            listener.ontClassDeleted(event);
        }
    }

    public void fireTPropertyCreated(String URI2, String name) {
        TPropertyEvent event = new TPropertyEvent(URI2, name);
        for (TPropertyListener listener : this.tPropertyListeners) {
            listener.tPropertyCreated(event);
        }
    }

    public void fireTPropertyDeleted(String URI2, String name) {
        TPropertyEvent event = new TPropertyEvent(URI2, name);
        for (TPropertyListener listener : this.tPropertyListeners) {
            listener.tPropertyDeleted(event);
        }
    }

    public void fireOPropertyCreated(String URI2, String name) {
        OPropertyEvent event = new OPropertyEvent(URI2, name);
        for (OPropertyListener listener : this.oPropertyListeners) {
            listener.oPropertyCreated(event);
        }
    }

    public void fireOPropertyDeleted(String URI2, String name) {
        OPropertyEvent event = new OPropertyEvent(URI2, name);
        for (OPropertyListener listener : this.oPropertyListeners) {
            listener.oPropertyDeleted(event);
        }
    }

    public void fireOntologyCreate(String URI2) {
        OntologyEvent event = new OntologyEvent(URI2);
        for (OntoListener listener : this.ontoListeners) {
            listener.ontologyCreated(event);
        }
    }

    public void fireOntologyDeleted(String URI2) {
        OntologyEvent event = new OntologyEvent(URI2);
        for (OntoListener listener : this.ontoListeners) {
            listener.ontologyDeleted(event);
        }
    }

    public void fireOntObjectCreated(String URI2, String name) {
        OntObjectEvent event = new OntObjectEvent(URI2, name);
        for (OntObjectListener listener : this.ontObjectListeners) {
            listener.ontObjectCreated(event);
        }
    }

    public void fireOntObjectDeleted(String URI2, String name) {
        OntObjectEvent event = new OntObjectEvent(URI2, name);
        for (OntObjectListener listener : this.ontObjectListeners) {
            listener.ontObjectDeleted(event);
        }
    }

    public void fireOntologyRenamed(String oldURI, String newURI) {
        OntologyRenamedEvent event = new OntologyRenamedEvent(oldURI, newURI);
        for (OntoListener listener : this.ontoListeners) {
            listener.ontologyRenamed(event);
        }
    }

    public void fireNamedEntityRenamed(String uri, String oldName, String newName) {
        NamedEntityRenamedEvent event = new NamedEntityRenamedEvent(uri, oldName, newName);
        for (NamedEntityListener listener : this.namedEntityListeners) {
            listener.namedEntityRenamed(event);
        }
    }
}

