/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.Collection;
import java.util.List;
import org.meta2project.model.Connection;
import org.meta2project.model.FindOption;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.OntologyCleaner;
import org.meta2project.model.test.support.SessionTestCase;

public class DMapTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDMap() {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            List<String> values;
            TProperty tprop = this.ont.createTProperty("dmap", null, "http://ontobox.org/#dmapString", 0, null);
            cleaner.addEntity(tprop);
            int SIZE = 1000;
            String SHORT_PREFIX = "short";
            String LONG_PREFIX = "-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly";
            for (int t = 0; t < 1000; ++t) {
                String v = t % 2 == 0 ? "short" + String.valueOf(t) : "-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly" + t;
                OntObject ontObject = this.ont.createOntObject(v, new Object[0]);
                ontObject.addTPropertyString(tprop, v);
                cleaner.addEntity(ontObject);
            }
            for (OntObject ontObject : this.ont.getAllOntObjects()) {
                DMapTestCase.assertEquals((String)ontObject.getName(), (String)ontObject.getTPropertyString(tprop));
            }
            DMapTestCase.assertEquals((int)1000, (int)tprop.getAllValues().size());
            for (String s : tprop.getAllValues()) {
                DMapTestCase.assertTrue((s.contains("short") || s.contains("-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly") ? 1 : 0) != 0);
            }
            Collection<OntObject> results = this.ont.find(FindOption.AND, "short");
            DMapTestCase.assertEquals((int)500, (int)results.size());
            for (OntObject ontObject : results) {
                values = ontObject.getTPropertyStrings(tprop);
                DMapTestCase.assertEquals((int)1, (int)values.size());
                DMapTestCase.assertTrue((boolean)values.contains(ontObject.getName()));
                DMapTestCase.assertTrue((boolean)ontObject.getName().contains("short"));
            }
            results = this.ont.find(FindOption.AND, "-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly");
            DMapTestCase.assertEquals((int)500, (int)results.size());
            for (OntObject ontObject : results) {
                values = ontObject.getTPropertyStrings(tprop);
                DMapTestCase.assertEquals((int)1, (int)values.size());
                DMapTestCase.assertTrue((boolean)values.contains(ontObject.getName()));
                DMapTestCase.assertTrue((boolean)ontObject.getName().contains("-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly"));
            }
            results = this.ont.find(FindOption.OR, "-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly", "short");
            DMapTestCase.assertEquals((int)1000, (int)results.size());
            for (OntObject ontObject : results) {
                values = ontObject.getTPropertyStrings(tprop);
                DMapTestCase.assertEquals((int)1, (int)values.size());
                DMapTestCase.assertTrue((boolean)values.contains(ontObject.getName()));
                DMapTestCase.assertTrue((ontObject.getName().contains("short") || ontObject.getName().contains("-\u0410\u0411\u0412-\u0430\u0431\u0432-too-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directlytoo-big-value-for-storing-as-key-directly") ? 1 : 0) != 0);
            }
        }
        finally {
            cleaner.cleanup();
        }
    }
}

