/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.helper.MMapHelper;
import org.meta2project.model.test.support.OntologyCleaner;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.TempHelper;

public class MapHelperTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private OntObject createMap(Connection con) {
        OntObject ret = MMapHelper.create(con);
        BoxWorker worker = con.getWorker();
        TempHelper.makeTemporary(worker, worker.id(ret.getFullName()));
        return ret;
    }

    public void testMap() {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            String name;
            OntObject map = this.createMap(this.con);
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isOkey(this.con, map, "ru"));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isTkey(this.con, map, "ru"));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isTkey(this.con, map, "v"));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isOkey(this.con, map, "v"));
            String r1 = "\u041d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c";
            map.addTPropertyString(MMapHelper.tkey(this.con, map, "ru"), "\u041d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c");
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isMap(this.con, map));
            MapHelperTestCase.assertEquals((int)1, (int)this.con.getOntology("http://ontobox.org/map").getAllOntObjects().size());
            map.addTPropertyString(MMapHelper.tkey(this.con, map, "ru"), "\u041d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c-2");
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isMap(this.con, map));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isOkey(this.con, map, "ru"));
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isTkey(this.con, map, "ru"));
            String[] s = MMapHelper.getTKeys(this.con, map);
            MapHelperTestCase.assertEquals((int)1, (int)s.length);
            MapHelperTestCase.assertEquals((String)"ru", (String)s[0]);
            s = MMapHelper.getOKeys(this.con, map);
            MapHelperTestCase.assertEquals((int)0, (int)s.length);
            String v1 = "English";
            map.addTPropertyString(MMapHelper.tkey(this.con, map, "en"), "English");
            OntObject obj = this.ont.createOntObject(new Object[0]);
            cleaner.addEntity(obj);
            try {
                map.addOPropertyValue(MMapHelper.okey(this.con, map, "en"), obj);
                MapHelperTestCase.fail((String)"should rise exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            map.addOPropertyValue(MMapHelper.okey(this.con, map, "v"), obj);
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isTkey(this.con, map, "v"));
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isOkey(this.con, map, "v"));
            try {
                MMapHelper.tkey(this.con, map, "v");
            }
            catch (Exception e) {
                // empty catch block
            }
            MapHelperTestCase.assertEquals((String)"English", (String)map.getTPropertyString(MMapHelper.tkey(this.con, map, "en")));
            MapHelperTestCase.assertEquals((String)"\u041d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c", (String)map.getTPropertyString(MMapHelper.tkey(this.con, map, "ru")));
            MapHelperTestCase.assertEquals((String)obj.getFullName(), (String)map.getOPropertyValue(MMapHelper.okey(this.con, map, "v")).getFullName());
            ArrayList<String> names = new ArrayList<String>();
            for (OProperty oprop : map.getAllOProperties()) {
                name = MMapHelper.name(this.con, oprop);
                if (name == null) continue;
                names.add(name);
            }
            for (TProperty tprop : map.getAllTProperties()) {
                name = MMapHelper.name(this.con, tprop);
                if (name == null) continue;
                names.add(name);
            }
            MapHelperTestCase.assertTrue((boolean)names.contains("en"));
            MapHelperTestCase.assertTrue((boolean)names.contains("ru"));
            MapHelperTestCase.assertTrue((boolean)names.contains("v"));
            s = MMapHelper.getTKeys(this.con, map);
            MapHelperTestCase.assertEquals((int)2, (int)s.length);
            MapHelperTestCase.assertTrue((s[0].equals("en") || s[1].equals("en") ? 1 : 0) != 0);
            MapHelperTestCase.assertTrue((s[0].equals("ru") || s[1].equals("ru") ? 1 : 0) != 0);
            s = MMapHelper.getOKeys(this.con, map);
            MapHelperTestCase.assertEquals((int)1, (int)s.length);
            MapHelperTestCase.assertEquals((String)"v", (String)s[0]);
            OProperty oprop = this.ont.createOProperty("testmap", null, this.con.getOntClassByFullName("http://ontobox.org/map#Map"), null, null);
            cleaner.addEntity(oprop);
            OntObject obj2 = this.ont.createOntObject(new Object[0]);
            obj2.addOPropertyValue(oprop, map);
            cleaner.addEntity(obj2);
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isOkey(this.con, map, "v"));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isTkey(this.con, map, "v"));
            MMapHelper.removeKey(this.con, map, "v");
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isOkey(this.con, map, "v"));
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isTkey(this.con, map, "v"));
            map.addTPropertyString(MMapHelper.tkey(this.con, map, "v"), "English");
            MapHelperTestCase.assertFalse((boolean)MMapHelper.isOkey(this.con, map, "v"));
            MapHelperTestCase.assertTrue((boolean)MMapHelper.isTkey(this.con, map, "v"));
            BoxWorker worker = this.con.getWorker();
            String key = "v";
            String cl = "http://ontobox.org/map#tcl-" + key;
            boolean keyExists = worker.entity(cl) == Entity.ONTCLASS && worker.objects(worker.id(cl)).length != 0;
            System.out.println("keyExists: " + keyExists);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            cleaner.cleanup();
        }
        TempHelper.cleanUp(this.con.getWorker());
        MapHelperTestCase.assertEquals((int)0, (int)this.con.getOntology("http://ontobox.org/map").getAllOntObjects().size());
    }
}

