/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;

public class PoliOntologyCase
extends SessionTestCase {
    private Connection con;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
    }

    protected void tearDown() throws Exception {
        this.con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoli() throws Exception {
        Ontology classOntology = this.con.createOntology("http://ontology-for-classes");
        OntClass baseClass = classOntology.createOntClass("Base", new OntClass[0]);
        OntClass derClass = classOntology.createOntClass("Der", baseClass);
        OProperty oprop = classOntology.createOProperty("next-base", derClass, baseClass, 0, 1);
        TProperty tprop = classOntology.createTProperty("text-value", baseClass, "http://ontobox.org/#string", 0, 1);
        try {
            Ontology dataOntology = this.con.createOntology("http://ontology-for-objects");
            try {
                OntObject firstObj = dataOntology.createOntObject(new Object[0]);
                firstObj.addOntClass(baseClass);
                OntObject secondObj = dataOntology.createOntObject(new Object[0]);
                secondObj.addOntClass(derClass);
                try {
                    OntClass c = firstObj.getOntClasses().iterator().next();
                    PoliOntologyCase.assertEquals((String)c.getFullName(), (String)baseClass.getFullName());
                    PoliOntologyCase.assertEquals((Object)c, (Object)baseClass);
                    PoliOntologyCase.assertEquals((Object)c.getOntology(), (Object)classOntology);
                    PoliOntologyCase.assertEquals((Object)firstObj.getOntology(), (Object)dataOntology);
                    PoliOntologyCase.assertTrue((boolean)firstObj.getAllOntClasses().contains(baseClass));
                    c = secondObj.getOntClasses().iterator().next();
                    PoliOntologyCase.assertEquals((String)c.getFullName(), (String)derClass.getFullName());
                    PoliOntologyCase.assertEquals((Object)c, (Object)derClass);
                    PoliOntologyCase.assertEquals((Object)c.getOntology(), (Object)classOntology);
                    PoliOntologyCase.assertEquals((Object)secondObj.getOntology(), (Object)dataOntology);
                    PoliOntologyCase.assertTrue((boolean)secondObj.getAllOntClasses().contains(baseClass));
                    PoliOntologyCase.assertTrue((boolean)secondObj.getAllOntClasses().contains(derClass));
                    firstObj.addTPropertyString(tprop, "test");
                    PoliOntologyCase.assertEquals((String)firstObj.getTPropertyString(tprop), (String)"test");
                    PoliOntologyCase.assertTrue((boolean)firstObj.getAllTProperties().contains(tprop));
                    PoliOntologyCase.assertTrue((boolean)secondObj.getAllTProperties().contains(tprop));
                    secondObj.addOPropertyValue(oprop, firstObj);
                    try {
                        secondObj.addOPropertyValue(oprop, secondObj);
                        PoliOntologyCase.fail((String)"should fail");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    PoliOntologyCase.assertTrue((boolean)secondObj.getAllOProperties().contains(oprop));
                }
                finally {
                    secondObj.removeAllValues();
                    secondObj.delete();
                    firstObj.removeAllValues();
                    firstObj.delete();
                }
                OntClass baseClassData = dataOntology.createOntClass("Base", new OntClass[0]);
                try {
                    PoliOntologyCase.assertFalse((boolean)baseClassData.equals(baseClass));
                }
                finally {
                    baseClassData.delete();
                }
            }
            finally {
                dataOntology.delete();
            }
        }
        finally {
            tprop.delete();
            oprop.delete();
            derClass.delete();
            baseClass.delete();
            classOntology.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicClasses() throws Exception {
        Ontology ont = this.con.createOntology("http://onto1");
        Ontology ont2 = this.con.createOntology("http://onto2");
        try {
            OntClass cl = ont.createOntClass("basic1", new OntClass[0]);
            OntClass cl2 = ont2.createOntClass("basic2", new OntClass[0]);
            try {
                PoliOntologyCase.assertEquals((int)1, (int)ont.getBasicOntClasses().size());
                PoliOntologyCase.assertTrue((boolean)ont.getBasicOntClasses().contains(cl));
                PoliOntologyCase.assertEquals((int)1, (int)ont2.getBasicOntClasses().size());
                PoliOntologyCase.assertTrue((boolean)ont2.getBasicOntClasses().contains(cl2));
            }
            finally {
                cl2.delete();
                cl.delete();
            }
        }
        finally {
            ont2.delete();
            ont.delete();
        }
    }
}

