/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import org.meta2project.model.Connection;
import org.meta2project.model.NamedEntity;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.NotFoundException;

public class RenameTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    void testRename(NamedEntity ne) throws Exception {
        String oldName = ne.getName();
        ne.setName("newName123");
        RenameTestCase.assertEquals((String)"newName123", (String)ne.getName());
        ne.setName("newName123");
        RenameTestCase.assertEquals((String)"newName123", (String)ne.getName());
        ne.setName(oldName);
        RenameTestCase.assertEquals((String)oldName, (String)ne.getName());
        try {
            this.ont.createOntObject(oldName, new Object[0]);
            RenameTestCase.fail((String)"should raise AlreadyExistsException");
        }
        catch (AlreadyExistsException e) {
            // empty catch block
        }
        try {
            this.ont.createOntClass(oldName, new OntClass[0]);
            RenameTestCase.fail((String)"should raise AlreadyExistsException");
        }
        catch (AlreadyExistsException alreadyExistsException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntObjectRename() throws Exception {
        OntObject o = this.ont.createOntObject("name", new Object[0]);
        try {
            o = this.ont.getOntObject("name");
            o.setName("newName");
            try {
                this.ont.getOntObject("name");
                RenameTestCase.fail((String)"should raise NotFoundException");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            OntObject o2 = this.ont.getOntObject("newName");
            RenameTestCase.assertEquals((String)o.getFullName(), (String)o2.getFullName());
            OntClass cl = this.ont.createOntClass("a", new OntClass[0]);
            try {
                try {
                    o.setName("a");
                    RenameTestCase.fail((String)"should raise AlreadyExistsException");
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
            }
            finally {
                cl.delete();
            }
            this.testRename(o);
        }
        finally {
            o.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOntClassRename() throws Exception {
        OntClass cl = this.ont.createOntClass("name", new OntClass[0]);
        try {
            cl = this.ont.getOntClass("name");
            cl.setName("newName");
            try {
                this.ont.getOntClass("name");
                RenameTestCase.fail((String)"should raise NotFoundException");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            OntClass cl2 = this.ont.getOntClass("newName");
            RenameTestCase.assertEquals((String)cl.getFullName(), (String)cl2.getFullName());
            OntObject o = this.ont.createOntObject("a", new Object[0]);
            try {
                try {
                    cl.setName("a");
                    RenameTestCase.fail((String)"should raise AlreadyExistsException");
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
            }
            finally {
                o.delete();
            }
            this.testRename(cl);
        }
        finally {
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTProperyRename() throws Exception {
        TProperty tprop = this.ont.createTProperty("m", null, null, null, null);
        try {
            this.testRename(tprop);
        }
        finally {
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOProperyRename() throws Exception {
        OProperty oprop = this.ont.createOProperty("m", null, null, null, null);
        try {
            this.testRename(oprop);
        }
        finally {
            oprop.delete();
        }
    }
}

