/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.meta2project.model.Connection;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.meta2project.model.test.support.OntologyCleaner;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.exception.DomainException;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.SortMode;
import org.ontobox.box.helper.Sorter;

public class TPropertyTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://meta2.teacode.com/testcase");
    }

    protected void tearDown() {
        try {
            this.ont.delete();
            this.con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTPropertyDomain() throws Exception {
        OntClass cl1 = this.ont.createOntClass("c1", new OntClass[0]);
        OntClass cl2 = this.ont.createOntClass("c2", new OntClass[0]);
        OntClass cl3 = this.ont.createOntClass("c3", new OntClass[0]);
        try {
            cl1.addSubClass(cl3);
            TProperty t1 = this.ont.createTProperty("t1", cl1, "http://ontobox.org/#string", 0, 4);
            TProperty t2 = this.ont.createTProperty("t2", cl1, this.con.getTypeByFullName("http://ontobox.org/#int"), null, null);
            TProperty t3 = this.ont.createTProperty("t3", null, (Type)null, (Integer)0, (Integer)4);
            try {
                Collection<TProperty> tprops = this.ont.getAllTProperties();
                TPropertyTestCase.assertEquals((int)3, (int)tprops.size());
                TPropertyTestCase.assertTrue((boolean)tprops.contains(t1));
                TPropertyTestCase.assertTrue((boolean)tprops.contains(t2));
                TPropertyTestCase.assertTrue((boolean)tprops.contains(t3));
                TPropertyTestCase.assertTrue((null == t2.getMinCardinality() ? 1 : 0) != 0);
                TPropertyTestCase.assertTrue((null == t2.getMaxCardinality() ? 1 : 0) != 0);
                TPropertyTestCase.assertEquals((Object)0, (Object)t3.getMinCardinality());
                TPropertyTestCase.assertEquals((Object)4, (Object)t3.getMaxCardinality());
                TPropertyTestCase.assertEquals((Object)cl1, (Object)t1.getDomain());
                TPropertyTestCase.assertEquals((Object)cl1, (Object)t2.getDomain());
                TPropertyTestCase.assertTrue((t3.getDomain() == null ? 1 : 0) != 0);
                TPropertyTestCase.assertEquals((Object)this.con.getTypeByFullName("http://ontobox.org/#string"), (Object)t1.getRange());
                TPropertyTestCase.assertEquals((Object)this.con.getTypeByFullName("http://ontobox.org/#int"), (Object)t2.getRange());
                TPropertyTestCase.assertTrue((t3.getRange() == null ? 1 : 0) != 0);
                TPropertyTestCase.assertEquals((int)3, (int)this.ont.getAllTProperties().size());
                OntClass oldDomain = t1.getDomain();
                Type oldRange = t1.getRange();
                t1.setDomain(cl2);
                t1.setRange(null);
                TPropertyTestCase.assertEquals((Object)cl2, (Object)t1.getDomain());
                TPropertyTestCase.assertTrue((t1.getRange() == null ? 1 : 0) != 0);
                t1.setDomain(null);
                TPropertyTestCase.assertTrue((t1.getDomain() == null ? 1 : 0) != 0);
                t1.setDomain(oldDomain);
                t1.setRange(oldRange);
                TPropertyTestCase.assertEquals((Object)cl1, (Object)t1.getDomain());
                TPropertyTestCase.assertEquals((Object)cl1, (Object)t2.getDomain());
                TPropertyTestCase.assertTrue((t3.getDomain() == null ? 1 : 0) != 0);
                TPropertyTestCase.assertEquals((Object)this.con.getTypeByFullName("http://ontobox.org/#string"), (Object)t1.getRange());
                TPropertyTestCase.assertEquals((Object)this.con.getTypeByFullName("http://ontobox.org/#int"), (Object)t2.getRange());
                TPropertyTestCase.assertTrue((t3.getRange() == null ? 1 : 0) != 0);
                TPropertyTestCase.assertEquals((int)3, (int)this.ont.getAllTProperties().size());
                OntObject obj = this.ont.createOntObject(new Object[0]);
                try {
                    tprops = obj.getAllTProperties();
                    TPropertyTestCase.assertEquals((int)1, (int)tprops.size());
                    TPropertyTestCase.assertTrue((boolean)tprops.contains(t3));
                    try {
                        obj.addTPropertyString(t1, "test1");
                        TPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                    try {
                        obj.addTPropertyString(t2, "123.123");
                        TPropertyTestCase.fail((String)"should raise Exception");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    obj.addTPropertyString(t3, "e");
                    obj.addOntClass(cl2);
                    try {
                        obj.addTPropertyString(t1, "test2");
                        TPropertyTestCase.fail((String)"should raise DomainException");
                    }
                    catch (DomainException e) {
                        // empty catch block
                    }
                    obj.addOntClass(cl3);
                    obj.addTPropertyString(t1, "test3");
                    obj.addTPropertyString(t3, "e2");
                    TPropertyTestCase.assertEquals((String)obj.getTPropertyString(t1), (String)"test3");
                    tprops = obj.getAllTProperties();
                    TPropertyTestCase.assertEquals((int)3, (int)tprops.size());
                    TPropertyTestCase.assertTrue((boolean)tprops.contains(t1));
                    TPropertyTestCase.assertTrue((boolean)tprops.contains(t2));
                    TPropertyTestCase.assertTrue((boolean)tprops.contains(t3));
                }
                finally {
                    obj.delete();
                }
            }
            finally {
                t3.delete();
                t2.delete();
                t1.delete();
            }
        }
        finally {
            cl3.delete();
            cl2.delete();
            cl1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetValue() throws Exception {
        TProperty tprop = this.ont.createTProperty("testoprop", null, (Type)null, (Integer)0, null);
        try {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                try {
                    obj.addTPropertyString(tprop, null);
                    TPropertyTestCase.fail((String)"should raise Exception");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                obj.addTPropertyString(tprop, "value");
                TPropertyTestCase.assertEquals((String)obj.getTPropertyStrings(tprop).get(0), (String)"value");
                TPropertyTestCase.assertEquals((String)obj.getTPropertyString(tprop), (String)"value");
            }
            finally {
                obj.removeTValues(tprop);
                obj.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemove() throws Exception {
        TProperty tprop = this.ont.createTProperty("testoprop", null, (Type)null, (Integer)0, null);
        TProperty tprop2 = this.ont.createTProperty("testoprop2", null, (Type)null, (Integer)0, null);
        try {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                obj.addTPropertyString(tprop2, "dummy");
                obj.addTPropertyString(tprop, "123");
                obj.addTPropertyString(tprop, "356");
                obj.removeTPropertyValue(tprop, 1);
                List<String> vals = obj.getTPropertyStrings(tprop);
                TPropertyTestCase.assertEquals((int)1, (int)vals.size());
                TPropertyTestCase.assertTrue((boolean)vals.contains("123"));
                obj.removeTPropertyValue(tprop, 0);
                vals = obj.getTPropertyStrings(tprop);
                TPropertyTestCase.assertEquals((int)0, (int)vals.size());
                try {
                    obj.removeTPropertyValue(tprop, 0);
                    TPropertyTestCase.fail((String)"should raise DomainException");
                }
                catch (Exception e) {
                    // empty catch block
                }
                obj.addTPropertyString(tprop, "123");
                obj.addTPropertyString(tprop, "356");
                obj.removeTPropertyValue(tprop, 0);
                vals = obj.getTPropertyStrings(tprop);
                TPropertyTestCase.assertEquals((int)1, (int)vals.size());
                TPropertyTestCase.assertTrue((boolean)vals.contains("356"));
                obj.removeTPropertyValue(tprop, 0);
                vals = obj.getTPropertyStrings(tprop);
                TPropertyTestCase.assertEquals((int)0, (int)vals.size());
            }
            finally {
                obj.removeAllValues();
                obj.delete();
            }
        }
        finally {
            tprop.delete();
            tprop2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllValues() throws Exception {
        TProperty tprop = this.ont.createTProperty("testoprop", null, (Type)null, (Integer)0, null);
        try {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            OntObject obj2 = this.ont.createOntObject(new Object[0]);
            try {
                obj.addTPropertyString(tprop, "value");
                obj.addTPropertyString(tprop, "value2");
                obj.addTPropertyString(tprop, "123");
                obj.addTPropertyString(tprop, "444");
                obj2.addTPropertyString(tprop, "444");
                obj2.addTPropertyString(tprop, "a");
                List<String> v = tprop.getAllValues();
                TPropertyTestCase.assertTrue((boolean)v.contains("value"));
                TPropertyTestCase.assertTrue((boolean)v.contains("value2"));
                TPropertyTestCase.assertTrue((boolean)v.contains("123"));
                TPropertyTestCase.assertTrue((boolean)v.contains("444"));
                TPropertyTestCase.assertTrue((boolean)v.contains("a"));
                TPropertyTestCase.assertEquals((int)5, (int)v.size());
            }
            finally {
                obj.removeAllValues();
                obj.delete();
                obj2.removeAllValues();
                obj2.delete();
            }
        }
        finally {
            tprop.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllProperties() throws Exception {
        OntClass cl = this.ont.createOntClass("bbbb", new OntClass[0]);
        OntClass cl2 = this.ont.createOntClass("cccc", new OntClass[0]);
        try {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            try {
                obj.addOntClass(cl2);
                TPropertyTestCase.assertEquals((int)0, (int)cl.getAllTProperties().size());
                TPropertyTestCase.assertEquals((int)0, (int)cl2.getAllTProperties().size());
                TPropertyTestCase.assertEquals((int)0, (int)obj.getAllTProperties().size());
                TPropertyTestCase.assertEquals((int)0, (int)cl.getTProperties().size());
                TPropertyTestCase.assertEquals((int)0, (int)cl2.getTProperties().size());
                TProperty tprop = this.ont.createTProperty("n", null, null, null, null);
                try {
                    TPropertyTestCase.assertEquals((int)1, (int)cl.getAllTProperties().size());
                    TPropertyTestCase.assertTrue((boolean)cl.getAllTProperties().contains(tprop));
                    TPropertyTestCase.assertEquals((int)1, (int)cl2.getAllTProperties().size());
                    TPropertyTestCase.assertTrue((boolean)cl2.getAllTProperties().contains(tprop));
                    TPropertyTestCase.assertEquals((int)1, (int)obj.getAllTProperties().size());
                    TPropertyTestCase.assertTrue((boolean)obj.getAllTProperties().contains(tprop));
                    TPropertyTestCase.assertEquals((int)0, (int)cl.getTProperties().size());
                    TPropertyTestCase.assertEquals((int)0, (int)cl2.getTProperties().size());
                    TProperty tprop2 = this.ont.createTProperty("t", cl, null, null, null);
                    try {
                        TPropertyTestCase.assertEquals((int)2, (int)cl.getAllTProperties().size());
                        TPropertyTestCase.assertTrue((boolean)cl.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertEquals((int)1, (int)cl2.getAllTProperties().size());
                        TPropertyTestCase.assertFalse((boolean)cl2.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertEquals((int)1, (int)obj.getAllTProperties().size());
                        TPropertyTestCase.assertFalse((boolean)obj.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertEquals((int)1, (int)cl.getTProperties().size());
                        TPropertyTestCase.assertEquals((int)0, (int)cl2.getTProperties().size());
                        cl.addSubClass(cl2);
                        TPropertyTestCase.assertEquals((int)2, (int)cl.getAllTProperties().size());
                        TPropertyTestCase.assertTrue((boolean)cl.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertTrue((boolean)cl.getAllTProperties().contains(tprop));
                        TPropertyTestCase.assertEquals((int)2, (int)cl2.getAllTProperties().size());
                        TPropertyTestCase.assertTrue((boolean)cl2.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertTrue((boolean)cl2.getAllTProperties().contains(tprop));
                        TPropertyTestCase.assertEquals((int)2, (int)obj.getAllTProperties().size());
                        TPropertyTestCase.assertTrue((boolean)obj.getAllTProperties().contains(tprop2));
                        TPropertyTestCase.assertTrue((boolean)obj.getAllTProperties().contains(tprop));
                        TPropertyTestCase.assertEquals((int)1, (int)cl.getTProperties().size());
                        TPropertyTestCase.assertEquals((int)0, (int)cl2.getTProperties().size());
                    }
                    finally {
                        tprop2.delete();
                    }
                }
                finally {
                    tprop.delete();
                }
            }
            finally {
                obj.delete();
            }
        }
        finally {
            cl2.delete();
            cl.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTProperty() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("test", new OntClass[0]);
            cleaner.addEntity(cl);
            TProperty tprop = this.ont.createTProperty("integervalue", cl, this.con.getTypeByFullName("http://ontobox.org/#int"), (Integer)0, null);
            cleaner.addEntity(tprop);
            TProperty tprop2 = this.ont.createTProperty("stringvalue", cl, "http://ontobox.org/#string", 0, null);
            cleaner.addEntity(tprop2);
            TProperty tprop3 = this.ont.createTProperty("booleanvalue", cl, "http://ontobox.org/#boolean", 0, null);
            cleaner.addEntity(tprop3);
            TProperty tprop4 = this.ont.createTProperty("doubletvalue", cl, "http://ontobox.org/#double", 0, null);
            cleaner.addEntity(tprop4);
            OntObject obj = this.ont.createOntObject("t", cl);
            cleaner.addEntity(obj);
            obj.addTPropertyString(tprop2, "just a value");
            obj.addTPropertyString(tprop, "123");
            try {
                obj.addTPropertyString(tprop, "bbbb");
                TPropertyTestCase.fail((String)"should raise Exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                obj.addTPropertyString(tprop, String.valueOf(Long.MAX_VALUE));
                TPropertyTestCase.fail((String)"should raise Exception");
            }
            catch (Exception e) {
                // empty catch block
            }
            obj.addTPropertyString(tprop3, "true");
            obj.addTPropertyString(tprop3, "false");
            obj.addTPropertyString(tprop3, "TRUE");
            obj.addTPropertyString(tprop3, "False");
            obj.addTPropertyString(tprop4, "-1");
            obj.addTPropertyString(tprop4, "-1.5");
            obj.addTPropertyString(tprop4, "1.");
            try {
                obj.addTPropertyString(tprop4, "a1");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStrings() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            TProperty tprop = this.ont.createTProperty("strings", null, null, null, null);
            cleaner.addEntity(tprop);
            OntObject obj = this.ont.createOntObject(new Object[0]);
            cleaner.addEntity(obj);
            obj.addTPropertyString(tprop, "value with spaces");
            obj.addTPropertyString(tprop, "new\nline\n");
            obj.addTPropertyString(tprop, " ");
            obj.addTPropertyString(tprop, String.valueOf('\u001f'));
            obj.addTPropertyString(tprop, "");
            obj.addTPropertyString(tprop, "?");
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBinary() throws Exception {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            TProperty tprop = this.ont.createTProperty("strings", null, "http://ontobox.org/#dmapBinary", 0, null);
            cleaner.addEntity(tprop);
            OntObject obj = this.ont.createOntObject(new Object[0]);
            cleaner.addEntity(obj);
            BoxWorker worker = this.con.getWorker();
            int o = worker.id(obj.getFullName());
            int t = worker.id(tprop.getFullName());
            worker.write().addBinary(o, t, new byte[]{0, -1, 127, -127});
            String s = "AP9/gQ==";
            TPropertyTestCase.assertEquals((String)s, (String)worker.strings(o, t)[0]);
            System.out.println(Arrays.toString(worker.binaries(o, t)[0]));
            worker.write().removeValues(o);
            worker.write().addString(o, t, s);
            TPropertyTestCase.assertEquals((String)s, (String)worker.strings(o, t)[0]);
            System.out.println(Arrays.toString(worker.binaries(o, t)[0]));
            BoxWriter writer = worker.write();
            Random rnd = new Random();
            for (int i = 0; i < 100; ++i) {
                byte[] v = new byte[i];
                rnd.nextBytes(v);
                writer.addBinary(o, t, v);
            }
            try {
                writer.addString(o, t, "!@#$%");
                TPropertyTestCase.fail((String)"should raise exeption");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                writer.addString(o, t, "!@#$");
                TPropertyTestCase.fail((String)"should raise exeption");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                writer.addString(o, t, "=aaa");
                TPropertyTestCase.fail((String)"should raise exeption");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            cleaner.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOwner() {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntObject obj;
            int t;
            OntClass cl = this.ont.createOntClass("owner", new OntClass[0]);
            cleaner.addEntity(cl);
            TProperty tprop1 = this.ont.createTProperty("tprop1", cl, "http://ontobox.org/#dmapString", 0, null);
            cleaner.addEntity(tprop1);
            TProperty tprop2 = this.ont.createTProperty("tprop2", cl, null, null, null);
            cleaner.addEntity(tprop2);
            int SIZE = 1000;
            for (t = 0; t < 1000; ++t) {
                obj = this.ont.createOntObject("object" + (t + 1000), new Object[0]);
                cleaner.addEntity(obj);
                obj.addOntClass(cl);
                obj.addTPropertyString(tprop1, "a");
                if (t % 2 != 0) continue;
                obj.addTPropertyString(tprop1, "a");
            }
            for (t = 0; t < 1000; ++t) {
                obj = this.ont.createOntObject("object" + (t + 2000), new Object[0]);
                cleaner.addEntity(obj);
                obj.addOntClass(cl);
                obj.addTPropertyString(tprop2, "b");
                if (t % 2 != 0) continue;
                obj.addTPropertyString(tprop2, "a");
            }
            TPropertyTestCase.verifyOwners(tprop1.getOwners("a"), 1000, "1");
            TPropertyTestCase.assertEquals((int)0, (int)tprop1.getOwners("b").size());
            TPropertyTestCase.verifyOwners(tprop2.getOwners("a"), 500, "2");
            TPropertyTestCase.verifyOwners(tprop2.getOwners("b"), 1000, "2");
        }
        finally {
            cleaner.cleanup();
        }
    }

    private static void verifyOwners(Collection<OntObject> owners, int expectedSize, String startString) {
        TPropertyTestCase.assertEquals((int)expectedSize, (int)owners.size());
        HashSet<OntObject> set = new HashSet<OntObject>(owners);
        TPropertyTestCase.assertEquals((int)owners.size(), (int)set.size());
        for (OntObject ontObject : owners) {
            String name = ontObject.getName();
            TPropertyTestCase.assertEquals((int)10, (int)name.length());
            TPropertyTestCase.assertTrue((boolean)name.startsWith("object" + startString));
            TPropertyTestCase.assertTrue((boolean)set.contains(ontObject));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSorter() {
        OntologyCleaner cleaner = new OntologyCleaner();
        try {
            OntClass cl = this.ont.createOntClass("cl", new OntClass[0]);
            cleaner.addEntity(cl);
            final TProperty str = this.ont.createTProperty("s", cl, (String)null, 0, (Integer)null);
            cleaner.addEntity(str);
            for (int t = 0; t < 1000; ++t) {
                OntObject o = this.ont.createOntObject(cl);
                cleaner.addEntity(o);
                String v = String.valueOf(t);
                o.addTPropertyString(str, "000".substring(v.length()) + v);
            }
            final BoxWorker worker = this.con.getWorker();
            int[] allObjects = worker.objects(worker.id(cl.getFullName()));
            int[] sorted = Sorter.sortTyped(allObjects, SortMode.DESC, new Sorter.ValueGenerator(){

                @Override
                public Comparable value(int objectId) {
                    return RHelper.stringValue(worker, objectId, str.getFullName());
                }
            });
            int prev = Integer.MAX_VALUE;
            for (int objectId : sorted) {
                int v = Integer.parseInt(RHelper.stringValue(worker, objectId, str.getFullName()));
                if (v >= prev) {
                    TPropertyTestCase.fail((String)(v + ">=" + prev));
                }
                prev = v;
            }
        }
        finally {
            cleaner.cleanup();
        }
    }
}

