/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.Session;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;
import org.ontobox.box.exception.NotFoundException;

public class TransactionTestCase
extends SessionTestCase {
    private static final String NAME = "http://transaction.test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransaction() throws Exception {
        int oldSize;
        Connection con = this.session.openTransaction();
        try {
            oldSize = con.getOntologies().size();
            Ontology ont = con.createOntology(NAME);
            OntClass cl = ont.createOntClass("testclass", new OntClass[0]);
            ont.createOntObject("testobject", cl);
            Collection<Ontology> onts = con.getOntologies();
            TransactionTestCase.assertTrue((boolean)onts.contains(con.getOntology(NAME)));
            cl = con.getOntClassByFullName("http://transaction.test#testclass");
            OntObject ontObject = con.getOntObjectByFullName("http://transaction.test#testobject");
            Collection<OntClass> ontClassCollection = ontObject.getOntClasses();
            TransactionTestCase.assertEquals((int)1, (int)ontClassCollection.size());
            TransactionTestCase.assertTrue((boolean)ontClassCollection.contains(cl));
            TProperty tprop = ont.createTProperty("testtprop", cl, "http://ontobox.org/#string", 0, null);
            OProperty oprop = ont.createOProperty("testoprop", cl, cl, 0, null);
        }
        finally {
            con.closeRollback();
        }
        con = this.session.openConnection();
        try {
            Collection<Ontology> onts = con.getOntologies();
            try {
                con.getOntology(NAME);
                TransactionTestCase.fail((String)"should rise NotFoundException");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            TransactionTestCase.assertEquals((int)oldSize, (int)onts.size());
            TransactionTestCase.assertEquals(null, (Object)con.getEntity("http://transaction.test#testclass"));
            TransactionTestCase.assertEquals(null, (Object)con.getEntity("http://transaction.test#testobject"));
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStress() throws InterruptedException {
        String name = "http://stress-test";
        ArrayList<StressThread> threads = new ArrayList<StressThread>();
        for (int t = 0; t < 200; ++t) {
            threads.add(new StressThread(this.session, name));
        }
        try {
            for (StressThread thread : threads) {
                thread.start();
            }
        }
        catch (Throwable throwable) {
            for (StressThread thread : threads) {
                thread.join();
            }
            for (StressThread thread : threads) {
                TransactionTestCase.assertFalse((boolean)thread.failed);
            }
            throw throwable;
        }
        for (StressThread thread : threads) {
            thread.join();
        }
        for (StressThread thread : threads) {
            TransactionTestCase.assertFalse((boolean)thread.failed);
        }
    }

    protected static class StressThread
    extends Thread {
        protected final Session session;
        protected final String ontologyName;
        protected boolean failed = false;

        public StressThread(Session session, String ontologyName) {
            this.session = session;
            this.ontologyName = ontologyName;
        }

        @Override
        public void run() {
            Connection con = this.session.openTransaction();
            try {
                try {
                    con.getOntology(this.ontologyName);
                    throw new IllegalAccessException("ontology exists");
                }
                catch (Exception e) {
                    Ontology ont = con.createOntology(this.ontologyName);
                    if (!ont.getAllOntObjects().isEmpty()) {
                        throw new IllegalStateException("many objects");
                    }
                    for (int t = 0; t < 1000; ++t) {
                        ont.createOntObject(new Object[0]);
                    }
                    Random rnd = new Random();
                    if (rnd.nextBoolean()) {
                        con.closeRollback();
                        return;
                    }
                    for (OntObject object : ont.getAllOntObjects()) {
                        object.delete();
                    }
                    ont.delete();
                    con.close();
                }
            }
            catch (Exception e) {
                this.failed = true;
                e.printStackTrace();
                con.closeRollback();
            }
        }
    }
}

