/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client;

import com.teacode.swing.component.HorizontalPanel;
import com.teacode.swing.dialog.DialogSize;
import com.teacode.swing.exception.ErrorMessageDialog;
import com.teacode.swing.tool.SelectTextMouseListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.text.JTextComponent;
import org.meta2project.ontobox.client.Client;
import org.meta2project.ontobox.client.ClientResult;
import org.meta2project.ontobox.client.ColoredScreen;
import org.meta2project.ontobox.client.ColoredTextPane;
import org.meta2project.ontobox.client.ResponseException;

public class ClientDemo {
    public static JFrame createFrame() {
        JFrame frame = new JFrame("OntoBox Client v0.1a");
        final ColoredScreen area = new ColoredScreen();
        frame.getContentPane().add((Component)new JScrollPane(area), "Center");
        String lastHost = "http://localhost:8080/";
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            URL codeBase = bs.getCodeBase();
            lastHost = codeBase.toExternalForm();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!lastHost.endsWith("/")) {
            lastHost = lastHost + '/';
        }
        lastHost = lastHost + "server/m2p";
        final JTextField hostField = new JTextField(100);
        hostField.setText(lastHost);
        final JTextField loginField = new JTextField(14);
        final JPasswordField passwordField = new JPasswordField(14);
        final JTextArea queryField = new JTextArea(7, 80);
        final JCheckBox gzipField = new JCheckBox("GZip");
        final ColoredTextPane mappingField = new ColoredTextPane();
        mappingField.setEditable(false);
        gzipField.setToolTipText("Use on slow connections");
        queryField.setText("*:*/count(); *:*");
        queryField.setLineWrap(true);
        SelectTextMouseListener.install((JTextComponent)queryField);
        final JButton runButton = new JButton("Run");
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder(null);
        panel.add((Component)new JScrollPane(queryField));
        panel.add((Component)runButton);
        JPanel lowPanel = new JPanel(new BorderLayout());
        lowPanel.add((Component)panel, "Center");
        lowPanel.add((Component)mappingField, "Last");
        frame.getContentPane().add((Component)lowPanel, "Last");
        HorizontalPanel panel2 = new HorizontalPanel();
        panel2.setBorder(null);
        panel2.add((Component)new JLabel("Server:"));
        panel2.add((Component)hostField);
        panel2.add((Component)new JLabel(" Login:"));
        panel2.add((Component)loginField);
        panel2.add((Component)new JLabel(" Passwd:"));
        panel2.add((Component)passwordField);
        panel2.add((Component)gzipField);
        frame.getContentPane().add((Component)panel2, "First");
        final ActionListener listener = new ActionListener(){

            private void setFieldsEnabled(boolean enabled) {
                queryField.setEnabled(enabled);
                runButton.setEnabled(enabled);
                hostField.setEnabled(enabled);
                loginField.setEnabled(enabled);
                passwordField.setEnabled(enabled);
                gzipField.setEnabled(enabled);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                final String host = hostField.getText();
                final String login = loginField.getText();
                final String password = new String(passwordField.getPassword());
                final String query = queryField.getText();
                final boolean gzip = gzipField.isSelected();
                this.setFieldsEnabled(false);
                area.connect(query, host);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                    private ClientResult result;
                    private String error;
                    private Long time;

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            long t1 = System.currentTimeMillis();
                            Client client = new Client(new URL(host), login, password, gzip);
                            this.result = client.query(query);
                            long t2 = System.currentTimeMillis();
                            this.time = t2 - t1;
                        }
                        catch (ResponseException e) {
                            this.error = e.getResponseMessage() + " (" + e.getResponseCode() + ')';
                        }
                        catch (Throwable e) {
                            this.error = e.getMessage();
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        if (this.error != null) {
                            area.error(this.error);
                        }
                        if (this.result != null) {
                            String resultError = this.result.getError();
                            if (resultError != null) {
                                area.error(resultError);
                            } else {
                                area.done(this.time, this.result);
                                Map<String, String> map = this.result.getMapping();
                                ArrayList<String> prefixes = new ArrayList<String>(map.keySet());
                                Collections.sort(prefixes);
                                mappingField.setText("");
                                boolean first = true;
                                for (String prefix : prefixes) {
                                    if (first) {
                                        first = false;
                                    } else {
                                        mappingField.addMessage("\n", Color.BLACK, Color.WHITE);
                                    }
                                    mappingField.addMessage(prefix, Color.BLUE, Color.WHITE);
                                    mappingField.addMessage(": ", Color.GRAY, Color.WHITE);
                                    mappingField.addMessage(map.get(prefix), Color.BLACK, Color.WHITE);
                                }
                            }
                        }
                        this.setFieldsEnabled(true);
                        queryField.requestFocusInWindow();
                    }
                };
                worker.execute();
            }
        };
        runButton.addActionListener(listener);
        queryField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && e.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                    listener.actionPerformed(null);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        JMenuBar bar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem quit = new JMenuItem("Exit");
        quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        file.add(quit);
        JMenu screen = new JMenu("Screen");
        JMenuItem cls = new JMenuItem("Clear");
        cls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                area.clear();
            }
        });
        screen.add(cls);
        bar.add(file);
        bar.add(screen);
        frame.setJMenuBar(bar);
        frame.setDefaultCloseOperation(3);
        frame.setSize(DialogSize.calcViewSize());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        queryField.requestFocusInWindow();
        return frame;
    }

    public static void main(String[] args) throws IOException {
        try {
            ClientDemo.createFrame();
        }
        catch (Throwable tr) {
            new ErrorMessageDialog(null, "Epic Fail", tr).setVisible(true);
        }
    }
}

