/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client;

import java.awt.Color;
import java.util.Collection;
import org.meta2project.ontobox.client.ClientResult;
import org.meta2project.ontobox.client.ColoredTextPane;
import org.meta2project.ontobox.client.Screen;

public class ColoredScreen
extends ColoredTextPane
implements Screen {
    private static final int LIMIT = 40;
    private static final Color READY_COLOR = new Color(0.0f, 0.5f, 0.0f);
    private static final Color BACK_COLOR = Color.WHITE;
    private static final Color INFO_COLOR = Color.gray;
    private static final Color ERROR_COLOR = Color.RED;
    private static final Color RESULT_COLOR = Color.BLUE;
    private static final Color BASE_COLOR = Color.BLACK;

    public ColoredScreen() {
        this.setEditable(false);
        this.clear();
    }

    @Override
    public void clear() {
        this.setText("");
        this.addMessage("Ready\n", READY_COLOR, BACK_COLOR);
        this.addMessage(">", Color.GRAY, BACK_COLOR);
    }

    @Override
    public void connect(String query, String host) {
        this.addMessage(query + '\n' + host + "...", INFO_COLOR, BACK_COLOR);
    }

    @Override
    public void done(long time, ClientResult result) {
        String t = time + " ms";
        Long rawTime = result.getRawTime();
        if (rawTime != null) {
            t = rawTime + "/" + t;
        }
        this.addMessage(" (" + t + ", " + result.getReadBytes() + " bytes" + (result.isGZip() ? ", gzip" : "") + ")\n", INFO_COLOR, BACK_COLOR);
        int resultCount = 1;
        for (Collection<String> line : result.getResult()) {
            this.addMessage("#" + resultCount + " (" + line.size() + "): ", BASE_COLOR, BACK_COLOR);
            int count = 0;
            for (String s : line) {
                this.addMessage(s + ' ', RESULT_COLOR, BACK_COLOR);
                if (++count < 40) continue;
                this.addMessage("...and " + (line.size() - 40) + " more...", BASE_COLOR, BACK_COLOR);
                break;
            }
            this.addMessage("\n", RESULT_COLOR, BACK_COLOR);
            ++resultCount;
        }
        this.addMessage("\n>", INFO_COLOR, BACK_COLOR);
    }

    @Override
    public void error(String error) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("\nError: ").append(error).append("\n\n");
        this.addMessage(sb.toString(), ERROR_COLOR, BACK_COLOR);
        this.addMessage(">", INFO_COLOR, BACK_COLOR);
    }
}

