/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.ontobox.client;

import java.io.IOException;
import java.io.InputStream;

public class CounterInputStream
extends InputStream {
    private final InputStream in;
    private int loaded;

    public CounterInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        if (ret != -1) {
            ++this.loaded;
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.in.read(b);
        if (ret != -1) {
            this.loaded += ret;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.in.read(b, off, len);
        if (ret != -1) {
            this.loaded += ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = this.in.skip(n);
        if (ret > 0L) {
            this.loaded = (int)((long)this.loaded + ret);
        }
        return ret;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("not supported");
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public int getLoaded() {
        return this.loaded;
    }
}

