/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.base;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.util.Base64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.RequireLevel;
import org.ontobox.box.base.BaseBox;
import org.ontobox.box.exception.DomainException;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.box.helper.ArrayHelper;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.VMap;
import org.ontobox.box.helper.Values;
import org.ontobox.box.query.QContext;
import org.ontobox.box.query.Query;

public abstract class BaseBoxWorker
implements BoxWorker {
    protected final BaseBox box;
    protected static final int[] EMPTY_INT = new int[0];
    protected static final long[] EMPTY_LONG = new long[0];
    protected static final String[] EMPTY_STRING = new String[0];
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    protected BaseBoxWorker(BaseBox box) {
        this.box = box;
    }

    @Override
    public int resolve(String name) {
        Integer id = this.id(name);
        if (id == null) {
            throw new NotFoundException("entity", name);
        }
        return id;
    }

    @Override
    public int resolve(String name, Entity type) {
        Integer id = this.id(name);
        if (id == null) {
            throw new NotFoundException(type.toString(), name);
        }
        Entity e = this.entity(id);
        if (e == null) {
            throw new NotFoundException(type.toString(), name);
        }
        if (e != type) {
            throw new NotFoundException(type.toString(), e.toString(), name);
        }
        return id;
    }

    private static String genList(Entity ... types) {
        StringBuilder sb = new StringBuilder(types.length * 10);
        boolean first = true;
        for (Entity type : types) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(type.toString());
        }
        return sb.toString();
    }

    @Override
    public Entity entity(String name) {
        Integer id = this.id(name);
        if (id == null) {
            return null;
        }
        return this.entity(id);
    }

    protected final Entity extractEntity(int id) {
        Entity e = this.entity(id);
        if (e == null) {
            throw new NotFoundException("entity", this.name(id));
        }
        return e;
    }

    protected final Entity extractEntity(int id, Entity type) {
        Entity e = this.entity(id);
        if (e == null) {
            throw new NotFoundException(BaseBoxWorker.genList(type), this.name(id));
        }
        if (type == e) {
            return e;
        }
        throw new NotFoundException(BaseBoxWorker.genList(type), e.toString(), this.name(id));
    }

    protected final Entity extractEntity(int id, Entity type1, Entity type2) {
        Entity e = this.entity(id);
        if (e == null) {
            throw new NotFoundException(BaseBoxWorker.genList(type1, type2), this.name(id));
        }
        if (type1 == e || type2 == e) {
            return e;
        }
        throw new NotFoundException(BaseBoxWorker.genList(type1, type2), e.toString(), this.name(id));
    }

    protected final Entity extractEntity(int id, Entity type1, Entity type2, Entity type3) {
        Entity e = this.entity(id);
        if (e == null) {
            throw new NotFoundException(BaseBoxWorker.genList(type1, type2, type3), this.name(id));
        }
        if (type1 == e || type2 == e || type3 == e) {
            return e;
        }
        throw new NotFoundException(BaseBoxWorker.genList(type1, type2, type3), e.toString(), this.name(id));
    }

    @Override
    public String name(int uri, String local) {
        String ont = this.name(uri);
        int size = ont.length() + 1 + local.length();
        StringBuilder sb = new StringBuilder(size);
        sb.append(ont).append('#').append(local);
        return sb.toString();
    }

    @Override
    public int ontology(int fn) {
        String name = this.name(fn);
        if (name == null) {
            throw new NotFoundException("Entity", "id=" + fn);
        }
        return this.id(NameHelper.splitName(name).ontology());
    }

    @Override
    public String local(int fn) {
        String name = this.name(fn);
        if (name == null) {
            throw new NotFoundException("Entity", "id=" + fn);
        }
        return NameHelper.splitName(name).local();
    }

    protected abstract int[] objectsForOntology(int var1);

    protected abstract int[] objectsForClass(int var1);

    @Override
    public int[] objects(int id) {
        Entity e = this.extractEntity(id, Entity.ONTOLOGY, Entity.ONTCLASS);
        if (e == Entity.ONTOLOGY) {
            return this.objectsForOntology(id);
        }
        return this.objectsForClass(id);
    }

    protected abstract int[] objectsDirectForClass(int var1);

    @Override
    public int[] objectsDirect(int id) {
        int[] ret = this.objectsDirectForClass(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTCLASS);
        }
        return ret;
    }

    protected abstract int[] classesForClass(int var1);

    protected abstract int[] classesForObject(int var1);

    protected abstract int[] classesForOntology(int var1);

    @Override
    public int[] classes(int id) {
        Entity e = this.extractEntity(id, Entity.ONTCLASS, Entity.ONTOBJECT, Entity.ONTOLOGY);
        if (e == Entity.ONTCLASS) {
            return this.classesForClass(id);
        }
        if (e == Entity.ONTOLOGY) {
            return this.classesForOntology(id);
        }
        return this.classesForObject(id);
    }

    protected abstract int[] classesDirectForClass(int var1);

    protected abstract int[] classesDirectForObject(int var1);

    protected abstract int[] classesDirectForOntology(int var1);

    @Override
    public int[] classesDirect(int id) {
        Entity e = this.extractEntity(id, Entity.ONTCLASS, Entity.ONTOBJECT, Entity.ONTOLOGY);
        if (e == Entity.ONTCLASS) {
            return this.classesDirectForClass(id);
        }
        if (e == Entity.ONTOLOGY) {
            return this.classesDirectForOntology(id);
        }
        return this.classesDirectForObject(id);
    }

    protected abstract int[] subclassesForClass(int var1);

    @Override
    public int[] subclasses(int id) {
        int[] ret = this.subclassesForClass(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTCLASS);
        }
        return ret;
    }

    protected abstract int[] subclassesDirectForClass(int var1);

    @Override
    public int[] subclassesDirect(int id) {
        int[] ret = this.subclassesDirectForClass(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTCLASS);
        }
        return ret;
    }

    protected abstract int[] typesForOntology(int var1);

    @Override
    public int[] types(int id) {
        return this.typesForOntology(id);
    }

    protected abstract int[] tpropsForClass(int var1);

    protected abstract int[] tpropsForObject(int var1);

    protected abstract int[] tpropsForOntology(int var1);

    @Override
    public int[] tprops(int id) {
        Entity e = this.extractEntity(id, Entity.ONTCLASS, Entity.ONTOBJECT, Entity.ONTOLOGY);
        if (e == Entity.ONTOLOGY) {
            return this.tpropsForOntology(id);
        }
        if (e == Entity.ONTCLASS) {
            return this.tpropsForClass(id);
        }
        return this.tpropsForObject(id);
    }

    protected abstract int[] tpropsDirectForClass(int var1);

    @Override
    public int[] tpropsDirect(int id) {
        int[] ret = this.tpropsDirectForClass(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTCLASS);
        }
        return ret;
    }

    protected abstract int[] opropsForClass(int var1);

    protected abstract int[] opropsForObject(int var1);

    protected abstract int[] opropsForOntology(int var1);

    @Override
    public int[] oprops(int id) {
        Entity e = this.extractEntity(id, Entity.ONTCLASS, Entity.ONTOBJECT, Entity.ONTOLOGY);
        if (e == Entity.ONTOLOGY) {
            return this.opropsForOntology(id);
        }
        if (e == Entity.ONTCLASS) {
            return this.opropsForClass(id);
        }
        return this.opropsForObject(id);
    }

    protected abstract int[] opropsDirectForClass(int var1);

    @Override
    public int[] opropsDirect(int id) {
        int[] ret = this.opropsDirectForClass(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTCLASS);
        }
        return ret;
    }

    protected abstract String[] stringsForTProperty(int var1);

    @Override
    public String[] strings(int id) {
        String[] ret = this.stringsForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected byte[][] bytesForTProperty(int id) {
        String[] strings = this.stringsForTProperty(id);
        byte[][] ret = new byte[strings.length][];
        for (int t = 0; t < strings.length; ++t) {
            try {
                ret[t] = Base64.decode((String)strings[t]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public final byte[][] binaries(int id) {
        byte[][] ret = this.bytesForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected int[] intsForTProperty(int id) {
        return ArrayHelper.stringsToInts(this.stringsForTProperty(id));
    }

    @Override
    public int[] ints(int id) {
        int[] ret = this.intsForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected long[] longsForTProperty(int id) {
        return ArrayHelper.stringsToLongs(this.stringsForTProperty(id));
    }

    @Override
    public long[] longs(int id) {
        long[] ret = this.longsForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected Date[] dateTimesForTProperty(int id) {
        return ArrayHelper.stringsToDateTimes(this.stringsForTProperty(id));
    }

    @Override
    public Date[] dateTimes(int id) {
        Date[] ret = this.dateTimesForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected boolean[] booleansForTProperty(int id) {
        return ArrayHelper.stringsToBooleans(this.stringsForTProperty(id));
    }

    @Override
    public boolean[] booleans(int id) {
        boolean[] ret = this.booleansForTProperty(id);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.TPROPERTY);
        }
        return ret;
    }

    protected void assertDomain(int object, int prop) {
        Integer domain = this.domain(prop);
        if (domain != null) {
            int d = domain;
            for (int i : this.classes(object)) {
                if (i != d) continue;
                return;
            }
            throw new DomainException(this.name(object), this.name(prop), this.name(domain));
        }
    }

    protected abstract String[] stringsForObject(int var1, int var2);

    @Override
    public final String[] strings(int id, int prop) {
        String[] ret = this.stringsForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected byte[][] bytesForObject(int id, int prop) {
        String[] strings = this.stringsForObject(id, prop);
        byte[][] ret = new byte[strings.length][];
        for (int t = 0; t < strings.length; ++t) {
            try {
                ret[t] = Base64.decode((String)strings[t]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public final byte[][] binaries(int id, int prop) {
        byte[][] ret = this.bytesForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected int[] intsForObject(int id, int prop) {
        return ArrayHelper.stringsToInts(this.stringsForObject(id, prop));
    }

    @Override
    public final int[] ints(int id, int prop) {
        int[] ret = this.intsForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected long[] longsForObject(int id, int prop) {
        return ArrayHelper.stringsToLongs(this.stringsForObject(id, prop));
    }

    @Override
    public final long[] longs(int id, int prop) {
        long[] ret = this.longsForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected Date[] dateTimesForObject(int id, int prop) {
        return ArrayHelper.stringsToDateTimes(this.stringsForObject(id, prop));
    }

    @Override
    public final Date[] dateTimes(int id, int prop) {
        Date[] ret = this.dateTimesForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected boolean[] booleansForObject(int id, int prop) {
        return ArrayHelper.stringsToBooleans(this.stringsForObject(id, prop));
    }

    @Override
    public final boolean[] booleans(int id, int prop) {
        boolean[] ret = this.booleansForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.TPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    @Override
    public void string(int object, int tprop, int index, Writer writer) {
        try {
            writer.write(this.strings(object, tprop)[index]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void string(int object, int tprop, int index, File file, String encoding) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
            try {
                this.string(object, tprop, index, writer);
            }
            finally {
                ((Writer)writer).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void binaries(int object, int tprop, int index, OutputStream out) {
        try {
            out.write(this.binaries(object, tprop)[index]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binaries(int object, int tprop, int index, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.binaries(object, tprop, index, out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract int[] ovaluesForObject(int var1, int var2);

    @Override
    public final int[] objects(int id, int prop) {
        int[] ret = this.ovaluesForObject(id, prop);
        if (ret.length == 0) {
            this.extractEntity(id, Entity.ONTOBJECT);
            this.extractEntity(prop, Entity.OPROPERTY);
            this.assertDomain(id, prop);
        }
        return ret;
    }

    protected abstract int[] ownersForOProperty(int var1, int var2);

    @Override
    public int[] owners(int prop, int value) {
        int[] ret = this.ownersForOProperty(prop, value);
        if (ret.length == 0) {
            this.extractEntity(prop, Entity.OPROPERTY);
        }
        return ret;
    }

    @Override
    public int[] owners(int obj) {
        IntList ret = CCreator.newIntList((int)16);
        for (int ontology : this.ontologies()) {
            for (int oprop : this.opropsForOntology(ontology)) {
                ret.addAll(this.ownersForOProperty(oprop, obj));
            }
        }
        if (ret.isEmpty()) {
            this.extractEntity(obj, Entity.ONTOBJECT);
        }
        return ret.toArray();
    }

    @Override
    public int[] owners(String value) {
        IntList ret = CCreator.newIntList((int)16);
        for (int ontology : this.ontologies()) {
            for (int tprop : this.tpropsForOntology(ontology)) {
                ret.addAll(this.ownersForTProperty(tprop, value));
            }
        }
        return ret.toArray();
    }

    protected abstract int[] ownersForTProperty(int var1, String var2);

    @Override
    public int[] owners(int prop, String value) {
        int[] ret = this.ownersForTProperty(prop, value);
        if (ret.length == 0) {
            this.extractEntity(prop, Entity.TPROPERTY);
        }
        return ret;
    }

    protected abstract Integer rangeForTProperty(int var1);

    protected abstract Integer rangeForOProperty(int var1);

    @Override
    public Integer range(int id) {
        Entity e = this.extractEntity(id, Entity.TPROPERTY, Entity.OPROPERTY);
        if (e == Entity.TPROPERTY) {
            return this.rangeForTProperty(id);
        }
        return this.rangeForOProperty(id);
    }

    protected abstract Integer domainForTProperty(int var1);

    protected abstract Integer domainForOProperty(int var1);

    @Override
    public Integer domain(int id) {
        Entity e = this.extractEntity(id, Entity.TPROPERTY, Entity.OPROPERTY);
        if (e == Entity.TPROPERTY) {
            return this.domainForTProperty(id);
        }
        return this.domainForOProperty(id);
    }

    protected abstract String annoForEntity(int var1, String var2);

    @Override
    public String anno(int id, String name) {
        String ret = this.annoForEntity(id, name);
        if (ret == null && this.extractEntity(id) == Entity.ONTOBJECT && !name.equals("http://ontobox.org/#Lock")) {
            throw new IllegalArgumentException("Annotations are not allowed for objects (" + name + ")");
        }
        return ret;
    }

    protected abstract String[] annamesForEntity(int var1);

    @Override
    public String[] annames(int id) {
        String[] ret = this.annamesForEntity(id);
        if (ret.length == 0 && this.extractEntity(id) == Entity.ONTOBJECT) {
            throw new IllegalArgumentException("Annotations are not allowed for objects");
        }
        return ret;
    }

    @Override
    public List<Values> q(QContext ctx, String query) {
        return QContext.convertListValues(this, ctx.execute((BoxWorker)this, query));
    }

    @Override
    public List<Values> q(QContext ctx, Query query) {
        return QContext.convertListValues(this, ctx.execute((BoxWorker)this, query));
    }

    @Override
    public Values qValues(QContext ctx, String query) {
        return QContext.convertValues(this, ctx.execute((BoxWorker)this, query));
    }

    @Override
    public Values qValues(QContext ctx, Query query) {
        return QContext.convertValues(this, ctx.execute((BoxWorker)this, query));
    }

    @Override
    public Integer qObject(QContext ctx, String query) {
        return this.qValues(ctx, query).object();
    }

    @Override
    public Integer qObject(QContext ctx, Query query) {
        return this.qValues(ctx, query).object();
    }

    @Override
    public List<Integer> qObjects(QContext ctx, String query) {
        return this.qValues(ctx, query).objects();
    }

    @Override
    public List<Integer> qObjects(QContext ctx, Query query) {
        return this.qValues(ctx, query).objects();
    }

    @Override
    public VMap qMap(QContext ctx, String query) {
        return this.qValues(ctx, query).map();
    }

    @Override
    public VMap qMap(QContext ctx, Query query) {
        return this.qValues(ctx, query).map();
    }

    @Override
    public List<VMap> qMaps(QContext ctx, String query) {
        return this.qValues(ctx, query).maps();
    }

    @Override
    public List<VMap> qMaps(QContext ctx, Query query) {
        return this.qValues(ctx, query).maps();
    }

    @Override
    public String qString(QContext ctx, String query) {
        return this.qValues(ctx, query).string();
    }

    @Override
    public String qString(QContext ctx, Query query) {
        return this.qValues(ctx, query).string();
    }

    @Override
    public List<String> qStrings(QContext ctx, String query) {
        return this.qValues(ctx, query).strings();
    }

    @Override
    public List<String> qStrings(QContext ctx, Query query) {
        return this.qValues(ctx, query).strings();
    }

    @Override
    public Date qDate(QContext ctx, String query) {
        return this.qValues(ctx, query).dateTime();
    }

    @Override
    public Date qDate(QContext ctx, Query query) {
        return this.qValues(ctx, query).dateTime();
    }

    @Override
    public List<Date> qDates(QContext ctx, String query) {
        return this.qValues(ctx, query).dateTimes();
    }

    @Override
    public List<Date> qDates(QContext ctx, Query query) {
        return this.qValues(ctx, query).dateTimes();
    }

    @Override
    public RequireLevel isRequired(int ont) {
        try {
            return RequireLevel.valueOf(this.anno(ont, "http://ontobox.org/#required"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setAttribute(String name, Object data) {
        this.attributes.put(name, data);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }
}

